/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.util.StringTokenizer;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Element;

public strictfp class Rectangle
extends Element
implements Cloneable {
    protected Point upperLeft;
    protected Point upperRight;
    protected Point lowerRight;
    protected Point lowerLeft;
    protected int xmin;
    protected int xmax;
    protected int ymin;
    protected int ymax;

    public Rectangle(Point start, Point end, Color color) {
        super(color);
        this.upperLeft = new Point(start);
        this.upperRight = new Point(end.x, start.y);
        this.lowerLeft = new Point(start.x, end.y);
        this.lowerRight = new Point(end);
    }

    public void setFilled(boolean fill) {
        this.filled = fill;
    }

    public Object clone() {
        Rectangle newRect = (Rectangle)super.clone();
        newRect.upperLeft = (Point)newRect.upperLeft.clone();
        newRect.upperRight = (Point)newRect.upperRight.clone();
        newRect.lowerLeft = (Point)newRect.lowerLeft.clone();
        newRect.lowerRight = (Point)newRect.lowerRight.clone();
        return newRect;
    }

    public void setMaxsAndMins() {
        int[] xcoords = new int[]{this.upperLeft.x, this.upperRight.x, this.lowerRight.x, this.lowerLeft.x};
        int[] ycoords = new int[]{this.upperLeft.y, this.upperRight.y, this.lowerRight.y, this.lowerLeft.y};
        this.xmin = this.min(xcoords);
        this.xmax = this.max(xcoords);
        this.ymin = this.min(ycoords);
        this.ymax = this.max(ycoords);
    }

    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        g.setColor(this.getColor(turtleColor));
        if (this.filled) {
            g.fillRect(this.upperLeft.x, this.upperLeft.y, this.upperRight.x - this.upperLeft.x, this.lowerLeft.y - this.upperLeft.y, scale, angle);
        } else {
            g.drawRect(this.upperLeft.x, this.upperLeft.y, this.upperRight.x - this.upperLeft.x, this.lowerLeft.y - this.upperLeft.y, scale, angle);
        }
    }

    public String toString() {
        return "Rectangle " + this.c.getRGB() + " " + this.filled + " " + this.marked + " " + this.upperLeft.x + " " + this.upperLeft.y + " " + this.lowerRight.x + " " + this.lowerRight.y;
    }

    public static Rectangle parseRectangle(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text);
        tokenizer.nextToken();
        String color = tokenizer.nextToken();
        boolean b1 = tokenizer.nextToken().equals("true");
        boolean b2 = tokenizer.nextToken().equals("true");
        int x1 = Integer.valueOf(tokenizer.nextToken());
        int y1 = Integer.valueOf(tokenizer.nextToken());
        int x2 = Integer.valueOf(tokenizer.nextToken());
        int y2 = Integer.valueOf(tokenizer.nextToken());
        if (x1 == x2 && y1 == y2) {
            return null;
        }
        Rectangle rect = new Rectangle(new Point(x1, y1), new Point(x2, y2), Color.decode(color));
        rect.setFilled(b1);
        rect.setMarked(b2);
        return rect;
    }
}

