/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Shape;
import org.nlogo.api.Version;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Element;
import org.nlogo.shape.Line;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class VectorShape
extends Observable
implements Serializable,
Cloneable,
Shape {
    protected String name = "";
    protected int editableColorIndex;
    protected List<Element> elementList = new ArrayList<Element>();
    protected boolean rotatable = true;
    private Recolorable fgRecolorable = Recolorable.UNKNOWN;

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setEditableColorIndex(int editableColorIndex) {
        this.editableColorIndex = editableColorIndex;
    }

    public Object clone() {
        VectorShape newShape;
        try {
            newShape = (VectorShape)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        newShape.elementList = new ArrayList<Element>();
        for (Element e : this.elementList) {
            newShape.elementList.add((Element)e.clone());
        }
        return newShape;
    }

    public void setOutline() {
        for (Element e : this.elementList) {
            e.setFilled(false);
        }
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public boolean fgRecolorable() {
        if (this.fgRecolorable == Recolorable.UNKNOWN) {
            this.fgRecolorable = Recolorable.FALSE;
            Color editableColor = new Color(org.nlogo.api.Color.getARGBByIndex(this.editableColorIndex));
            int n = this.elementList.size();
            for (int i = 0; i < n; ++i) {
                if (!this.element(i).getColor().equals(editableColor)) continue;
                this.fgRecolorable = Recolorable.TRUE;
                break;
            }
        }
        return this.fgRecolorable == Recolorable.TRUE;
    }

    public boolean isTooSimpleToCache() {
        switch (this.elementList.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = this.element(0);
                return !(element instanceof Polygon);
            }
        }
        return false;
    }

    protected Element element(int i) {
        return this.elementList.get(i);
    }

    public void add(Element element) {
        this.elementList.add(element);
        if (element instanceof Rectangle) {
            ((Rectangle)element).setMaxsAndMins();
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(GraphicsInterface g, Color turtleColor, double x, double y, double size, double cellSize, int angle, double lineThickness) {
        g.push();
        double scale = size * cellSize;
        if (!this.isRotatable()) {
            angle = 0;
        }
        try {
            if (angle != 0) {
                g.rotate((double)angle / 180.0 * Math.PI, x, y, scale);
            }
            g.translate(x, y);
            g.scale(scale, scale, 300.0);
            g.setStrokeFromLineThickness(lineThickness, scale, cellSize, 300.0);
            for (int i = 0; i < this.elementList.size(); ++i) {
                this.element(i).draw(g, turtleColor, scale, angle);
            }
        }
        finally {
            g.pop();
        }
    }

    public void paint(GraphicsInterface g, Color turtleColor, int x, int y, double cellSize, int angle) {
        this.paint(g, turtleColor, x, y, 1.0, cellSize, angle, 0.0);
    }

    public String toString() {
        String ret = this.name + "\n" + this.rotatable + "\n" + this.editableColorIndex;
        for (int i = 0; i < this.elementList.size(); ++i) {
            Element elt = this.elementList.get(i);
            if (!elt.shouldSave()) continue;
            ret = ret + "\n" + elt.toString();
        }
        return ret;
    }

    public void addElement(String line) {
        this.addElement(line, false);
    }

    public void addElement(String line, boolean translateClassicColorToNewColors) {
        Element element = null;
        if (line.startsWith("Line")) {
            element = Line.parseLine(line);
        } else if (line.startsWith("Rectangle")) {
            element = Rectangle.parseRectangle(line);
        } else if (line.startsWith("Circle")) {
            element = Circle.parseCircle(line);
        } else if (line.startsWith("Polygon")) {
            element = Polygon.parsePolygon(line);
        } else {
            throw new IllegalStateException("Invalid shape format in file: " + line);
        }
        if (element != null) {
            if (translateClassicColorToNewColors) {
                element.setColor(new Color(org.nlogo.api.Color.translateSavedColor(element.getColor().getRGB())));
            }
            this.add(element);
        }
    }

    public static List<Shape> parseShapes(String[] shapes, String version) {
        int index;
        ArrayList<Shape> ret = new ArrayList<Shape>();
        for (index = 0; shapes.length > index && 0 == VectorShape.getString(shapes, index).length(); ++index) {
        }
        while (shapes.length > index) {
            try {
                VectorShape shape = new VectorShape();
                index = VectorShape.parseShape(shapes, version, shape, index);
                ret.add(shape);
            }
            catch (IllegalStateException e) {
                continue;
            }
            ++index;
        }
        return ret;
    }

    public static int parseShape(String[] shapes, String version, VectorShape shape, int index) {
        boolean translateColors;
        shape.setName(VectorShape.getString(shapes, index++));
        if (shape.getName().indexOf("StarLogoT") != -1) {
            throw new IllegalStateException("found StarLogoT version instead of shape");
        }
        shape.setRotatable(VectorShape.getString(shapes, index++).equals("true"));
        int rgb = Integer.valueOf(VectorShape.getString(shapes, index++));
        boolean bl = translateColors = version != null && (Version.olderThan30pre5(version) || Version.olderThan3DPreview3(version));
        if (translateColors) {
            rgb = org.nlogo.api.Color.translateSavedColor(rgb);
        }
        shape.setEditableColorIndex(rgb);
        while (0 != VectorShape.getString(shapes, index).length()) {
            shape.addElement(VectorShape.getString(shapes, index++), translateColors);
        }
        return index;
    }

    static String getString(String[] v, int index) {
        if (null != v && v.length > index) {
            return v[index];
        }
        return "";
    }

    public static VectorShape getDefaultShape() {
        VectorShape result = new VectorShape();
        result.setName("default");
        result.setRotatable(true);
        result.setEditableColorIndex(0);
        result.addElement("Polygon -7500403 true true 150 5 40 250 150 205 260 250");
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp static enum Recolorable {
        UNKNOWN,
        TRUE,
        FALSE;

    }
}

