/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import net.roydesign.ui.FolderDialog;
import org.nlogo.awt.UserCancelException;
import org.nlogo.awt.Utils;

public strictfp final class FileDialog {
    private static String currentDirectory = System.getProperty("user.home");
    private static final boolean MAC = System.getProperty("os.name").startsWith("Mac");
    private static final boolean LINUX = System.getProperty("os.name").startsWith("Linux");

    private FileDialog() {
        throw new IllegalStateException();
    }

    public static void setDirectory(String directory) {
        currentDirectory = directory;
    }

    public static String show(Component component, String title, int mode, String file) throws UserCancelException {
        return FileDialog.show(Utils.getFrame(component), title, mode, false, file);
    }

    public static String show(Frame parentFrame, String title, int mode) throws UserCancelException {
        return FileDialog.show(parentFrame, title, mode, false);
    }

    public static String show(Frame parentFrame, String title, int mode, boolean directoriesOnly) throws UserCancelException {
        return FileDialog.show(parentFrame, title, mode, directoriesOnly, null);
    }

    private static String show(Frame parentFrame, String title, int mode, boolean directoriesOnly, String file) throws UserCancelException {
        if (LINUX) {
            int result;
            JFileChooser chooser = new JFileChooser(currentDirectory);
            chooser.setDialogTitle(title);
            if (file != null && file.length() > 0) {
                chooser.setSelectedFile(new File(file));
            }
            if (directoriesOnly) {
                chooser.setFileSelectionMode(1);
            }
            if ((result = mode == 0 ? chooser.showOpenDialog(parentFrame) : chooser.showSaveDialog(parentFrame)) != 0) {
                throw new UserCancelException();
            }
            return chooser.getSelectedFile().getAbsolutePath();
        }
        if (!MAC && directoriesOnly) {
            JFileChooser chooser = new JFileChooser(currentDirectory);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(parentFrame) != 0) {
                throw new UserCancelException();
            }
            return chooser.getSelectedFile().getAbsolutePath();
        }
        Object dialog = directoriesOnly ? new FolderDialog(parentFrame, title) : new java.awt.FileDialog(parentFrame, title, mode);
        if (!directoriesOnly) {
            ((java.awt.FileDialog)dialog).setDirectory(currentDirectory);
            if (file != null) {
                ((java.awt.FileDialog)dialog).setFile(file);
            }
        }
        ((Dialog)dialog).setVisible(true);
        if (!directoriesOnly && ((java.awt.FileDialog)dialog).getFile() == null || directoriesOnly && ((java.awt.FileDialog)dialog).getDirectory() == null) {
            throw new UserCancelException();
        }
        currentDirectory = ((java.awt.FileDialog)dialog).getDirectory();
        if (directoriesOnly) {
            return currentDirectory;
        }
        if (((java.awt.FileDialog)dialog).getDirectory() == null) {
            return ((java.awt.FileDialog)dialog).getFile();
        }
        return ((java.awt.FileDialog)dialog).getDirectory() + ((java.awt.FileDialog)dialog).getFile();
    }
}

