/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.util;

import java.io.Serializable;
import java.util.Random;
import java.util.StringTokenizer;

public strictfp final class MersenneTwisterFast
extends Random
implements Serializable,
Cloneable {
    private int[] __mt;
    private int mti;
    private int[] __mag01;
    private double __nextNextGaussian;
    private boolean __haveNextNextGaussian;

    public MersenneTwisterFast clone() {
        MersenneTwisterFast result;
        try {
            result = (MersenneTwisterFast)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        result.__mag01 = (int[])result.__mag01.clone();
        result.__mt = (int[])result.__mt.clone();
        return result;
    }

    public String save() {
        StringBuilder result = new StringBuilder("0 " + this.__mag01[0] + " " + this.__mag01[1] + " " + this.mti + " " + this.__nextNextGaussian + " " + this.__haveNextNextGaussian);
        for (int i = 0; i < 624; ++i) {
            result.append(" ");
            result.append(Integer.toString(this.__mt[i]));
        }
        return result.toString();
    }

    public void load(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s);
        String identifier = tokenizer.nextToken();
        if (!identifier.equals("0")) {
            throw new RuntimeException("identifier mismatch: expected \"0\", got \"" + identifier + "\"");
        }
        this.__mag01[0] = Integer.parseInt(tokenizer.nextToken());
        this.__mag01[1] = Integer.parseInt(tokenizer.nextToken());
        this.mti = Integer.parseInt(tokenizer.nextToken());
        this.__nextNextGaussian = Double.parseDouble(tokenizer.nextToken());
        String next = tokenizer.nextToken();
        if (next.equals("true")) {
            this.__haveNextNextGaussian = true;
        } else if (next.equals("false")) {
            this.__haveNextNextGaussian = false;
        } else {
            throw new RuntimeException("expected true or false, got \"" + next + "\"");
        }
        for (int i = 0; i < 624; ++i) {
            this.__mt[i] = Integer.parseInt(tokenizer.nextToken());
        }
        assert (!tokenizer.hasMoreTokens());
    }

    public MersenneTwisterFast() {
        this(System.nanoTime());
    }

    public MersenneTwisterFast(long seed) {
        this.setSeed(seed);
    }

    public synchronized void setSeed(long seed) {
        this.__haveNextNextGaussian = false;
        this.__mt = new int[624];
        this.__mag01 = new int[2];
        this.__mag01[0] = 0;
        this.__mag01[1] = -1727483681;
        this.__mt[0] = (int)(seed & 0xFFFFFFFFFFFFFFFFL);
        this.mti = 1;
        while (this.mti < 624) {
            this.__mt[this.mti] = 1812433253 * (this.__mt[this.mti - 1] ^ this.__mt[this.mti - 1] >>> 30) + this.mti;
            int n = this.mti++;
            this.__mt[n] = this.__mt[n] & 0xFFFFFFFF;
        }
    }

    public int nextInt() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    public boolean nextBoolean() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        return (y ^= y >>> 18) >>> 31 != 0;
    }

    public void nextBytes(byte[] bytes) {
        for (int x = 0; x < bytes.length; ++x) {
            int y;
            if (this.mti >= 624) {
                int kk;
                int[] mt = this.__mt;
                int[] mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
                }
                while (kk < 623) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                    ++kk;
                }
                y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
                this.mti = 0;
            }
            y = this.__mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
            y ^= y >>> 18;
            bytes[x] = (byte)(y >>> 24);
        }
    }

    public long nextLong() {
        int z;
        int y;
        int kk;
        int[] mag01;
        int[] mt;
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ z >>> 1 ^ mag01[z & 1];
            }
            while (kk < 623) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ z >>> 1 ^ mag01[z & 1];
                ++kk;
            }
            z = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ z >>> 1 ^ mag01[z & 1];
            this.mti = 0;
        }
        z = this.__mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        z ^= z >>> 18;
        return ((long)y << 32) + (long)z;
    }

    public long nextLong(long n) {
        long val;
        int z;
        int y;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        do {
            int kk;
            int[] mag01;
            int[] mt;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
                }
                while (kk < 623) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                    ++kk;
                }
                y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
                this.mti = 0;
            }
            y = this.__mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
            y ^= y >>> 18;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ z >>> 1 ^ mag01[z & 1];
                }
                while (kk < 623) {
                    z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ z >>> 1 ^ mag01[z & 1];
                    ++kk;
                }
                z = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ z >>> 1 ^ mag01[z & 1];
                this.mti = 0;
            }
            z = this.__mt[this.mti++];
            z ^= z >>> 11;
            z ^= z << 7 & 0x9D2C5680;
            z ^= z << 15 & 0xEFC60000;
        } while ((bits = ((long)y << 32) + (long)(z ^= z >>> 18) >>> 1) - (val = bits % n) + (n - 1L) < 0L);
        return val;
    }

    public double nextDouble() {
        int z;
        int y;
        int kk;
        int[] mag01;
        int[] mt;
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            mt = this.__mt;
            mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ z >>> 1 ^ mag01[z & 1];
            }
            while (kk < 623) {
                z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ z >>> 1 ^ mag01[z & 1];
                ++kk;
            }
            z = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ z >>> 1 ^ mag01[z & 1];
            this.mti = 0;
        }
        z = this.__mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        z ^= z >>> 18;
        return (double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15;
    }

    public double nextGaussian() {
        int b;
        int a;
        double v2;
        int z;
        int y;
        double v1;
        double s;
        if (this.__haveNextNextGaussian) {
            this.__haveNextNextGaussian = false;
            return this.__nextNextGaussian;
        }
        do {
            int kk;
            int[] mag01;
            int[] mt;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
                }
                while (kk < 623) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                    ++kk;
                }
                y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
                this.mti = 0;
            }
            y = this.__mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
            y ^= y >>> 18;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ z >>> 1 ^ mag01[z & 1];
                }
                while (kk < 623) {
                    z = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ z >>> 1 ^ mag01[z & 1];
                    ++kk;
                }
                z = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ z >>> 1 ^ mag01[z & 1];
                this.mti = 0;
            }
            z = this.__mt[this.mti++];
            z ^= z >>> 11;
            z ^= z << 7 & 0x9D2C5680;
            z ^= z << 15 & 0xEFC60000;
            z ^= z >>> 18;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    a = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ a >>> 1 ^ mag01[a & 1];
                }
                while (kk < 623) {
                    a = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ a >>> 1 ^ mag01[a & 1];
                    ++kk;
                }
                a = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ a >>> 1 ^ mag01[a & 1];
                this.mti = 0;
            }
            a = this.__mt[this.mti++];
            a ^= a >>> 11;
            a ^= a << 7 & 0x9D2C5680;
            a ^= a << 15 & 0xEFC60000;
            a ^= a >>> 18;
            if (this.mti >= 624) {
                mt = this.__mt;
                mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    b = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ b >>> 1 ^ mag01[b & 1];
                }
                while (kk < 623) {
                    b = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ b >>> 1 ^ mag01[b & 1];
                    ++kk;
                }
                b = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ b >>> 1 ^ mag01[b & 1];
                this.mti = 0;
            }
            b = this.__mt[this.mti++];
            b ^= b >>> 11;
            b ^= b << 7 & 0x9D2C5680;
            b ^= b << 15 & 0xEFC60000;
        } while ((s = (v1 = 2.0 * ((double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15) - 1.0) * v1 + (v2 = 2.0 * ((double)(((long)(a >>> 6) << 27) + (long)((b ^= b >>> 18) >>> 5)) / 9.007199254740992E15) - 1.0) * v2) >= 1.0 || s == 0.0);
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.__nextNextGaussian = v2 * multiplier;
        this.__haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public float nextFloat() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.__mt;
            int[] mag01 = this.__mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.__mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (float)(y >>> 8) / 1.6777216E7f;
    }

    public int nextInt(int n) {
        int val;
        int y;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            int y2;
            if (this.mti >= 624) {
                int kk;
                int[] mt = this.__mt;
                int[] mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y2 >>> 1 ^ mag01[y2 & 1];
                }
                while (kk < 623) {
                    y2 = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y2 >>> 1 ^ mag01[y2 & 1];
                    ++kk;
                }
                y2 = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y2 >>> 1 ^ mag01[y2 & 1];
                this.mti = 0;
            }
            y2 = this.__mt[this.mti++];
            y2 ^= y2 >>> 11;
            y2 ^= y2 << 7 & 0x9D2C5680;
            y2 ^= y2 << 15 & 0xEFC60000;
            y2 ^= y2 >>> 18;
            return (int)((long)n * (long)(y2 >>> 1) >> 31);
        }
        do {
            if (this.mti >= 624) {
                int kk;
                int[] mt = this.__mt;
                int[] mag01 = this.__mag01;
                for (kk = 0; kk < 227; ++kk) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
                }
                while (kk < 623) {
                    y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                    mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                    ++kk;
                }
                y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
                mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
                this.mti = 0;
            }
            y = this.__mt[this.mti++];
            y ^= y >>> 11;
            y ^= y << 7 & 0x9D2C5680;
            y ^= y << 15 & 0xEFC60000;
        } while ((bits = (y ^= y >>> 18) >>> 1) - (val = bits % n) + (n - 1) < 0);
        return val;
    }

    protected int next(int bits) {
        throw new UnsupportedOperationException();
    }
}

