/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.Editable;
import org.nlogo.api.File;
import org.nlogo.api.Options;
import org.nlogo.api.PropertyDescription;
import org.nlogo.api.Version;
import org.nlogo.awt.DarkenImageFilter;
import org.nlogo.awt.Utils;
import org.nlogo.log.Logger;
import org.nlogo.util.MersenneTwisterFast;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.JobWidget;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class ButtonWidget
extends JobWidget
implements MouseListener,
MouseMotionListener,
Editable,
Events.JobRemovedEvent.Handler {
    private boolean foreverOn = false;
    private boolean buttonUp = true;
    protected boolean forever = false;
    private char actionKey = '\u0000';
    private boolean keyEnabled = false;
    private boolean lastMousePressedWasPopupTrigger = false;
    private Options<Class<? extends Agent>> agentOptions = new Options();
    private boolean running;
    private boolean stopping = false;
    private String name = "";
    private static final ImageIcon FOREVER_GRAPHIC = new ImageIcon(ButtonWidget.class.getResource("/images/forever2.gif"));
    private static final ImageIcon FOREVER_GRAPHIC_DARK = new ImageIcon(ButtonWidget.class.getResource("/images/forever.gif"));
    private static final ImageIcon TURTLE_GRAPHIC = new ImageIcon(ButtonWidget.class.getResource("/images/turtle.gif"));
    private static final ImageIcon TURTLE_GRAPHIC_DARK = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(TURTLE_GRAPHIC.getImage().getSource(), new DarkenImageFilter(0.5))));
    private static final ImageIcon PATCH_GRAPHIC = new ImageIcon(ButtonWidget.class.getResource("/images/patch.gif"));
    private static final ImageIcon PATCH_GRAPHIC_DARK = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(PATCH_GRAPHIC.getImage().getSource(), new DarkenImageFilter(0.5))));
    private static final ImageIcon LINK_GRAPHIC = new ImageIcon(ButtonWidget.class.getResource("/images/link.gif"));
    private static final ImageIcon LINK_GRAPHIC_DARK = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(LINK_GRAPHIC.getImage().getSource(), new DarkenImageFilter(0.5))));

    public ButtonWidget(MersenneTwisterFast mersenneTwisterFast) {
        super(mersenneTwisterFast);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(InterfaceColors.BUTTON_BACKGROUND);
        this.setBorder(this.widgetBorder);
        this.agentOptions().addOption("Observer", Observer.class);
        this.agentOptions().addOption("Turtles", Turtle.class);
        this.agentOptions().addOption("Patches", Patch.class);
        this.agentOptions().addOption("Links", Link.class);
        this.agentClass(Observer.class);
        this.agentOptions().selectValue(this.agentClass());
        Utils.adjustDefaultFont(this);
    }

    public boolean buttonUp() {
        return this.buttonUp;
    }

    public void buttonUp(boolean buttonUp) {
        if (buttonUp) {
            this.foreverOn = false;
        }
        this.buttonUp = buttonUp;
        if (buttonUp) {
            this.setBorder(this.widgetBorder);
        } else {
            this.setBorder(this.widgetPressedBorder);
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public boolean forever() {
        return this.forever;
    }

    public void forever(boolean forever) {
        if (forever != this.forever) {
            this.forever = forever;
            this.stopping = false;
            this.recompile();
            this.repaint();
        }
    }

    public char actionKey() {
        return this.actionKey;
    }

    public void actionKey(char actionKey) {
        this.actionKey = actionKey;
    }

    private String actionKeyString() {
        return this.actionKey == '\u0000' ? "" : Character.toString(this.actionKey);
    }

    public void keyEnabled(boolean keyEnabled) {
        if (this.keyEnabled != keyEnabled) {
            this.keyEnabled = keyEnabled;
            this.repaint();
        }
    }

    public void keyTriggered() {
        if (this.error != null) {
            return;
        }
        this.buttonUp(false);
        this.respondToClick(true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.error != null) {
            return;
        }
        if (!e.isPopupTrigger() && this.isEnabled() && !this.lastMousePressedWasPopupTrigger) {
            e.translatePoint(this.getX(), this.getY());
            this.respondToClick(this.getBounds().contains(e.getPoint()));
        }
    }

    private void respondToClick(boolean inBounds) {
        if (this.error != null) {
            return;
        }
        if (this.forever()) {
            if (inBounds) {
                this.foreverOn = !this.foreverOn;
                this.buttonUp(!this.foreverOn);
                this.action();
            } else {
                this.buttonUp(!this.foreverOn);
            }
        } else {
            this.buttonUp(true);
            if (inBounds) {
                this.action();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        new Events.InputBoxLoseFocusEvent().raise(this);
        this.lastMousePressedWasPopupTrigger = e.isPopupTrigger();
        if (this.error != null) {
            return;
        }
        if (!e.isPopupTrigger() && Utils.button1Mask(e) && this.isEnabled()) {
            this.buttonUp(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.error != null) {
            return;
        }
        if (Utils.button1Mask(e) && this.isEnabled()) {
            e.translatePoint(this.getX(), this.getY());
            if (this.getBounds().contains(e.getPoint())) {
                this.buttonUp(false);
            } else if (!this.forever() || !this.foreverOn) {
                this.buttonUp(true);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isPopupTrigger() && this.error != null && !this.lastMousePressedWasPopupTrigger && Utils.button1Mask(e)) {
            new Events.EditWidgetEvent(this, false).raise(this);
            return;
        }
    }

    @Override
    public String classDisplayName() {
        return "Button";
    }

    @Override
    public List<PropertyDescription> propertySet() {
        ArrayList<PropertyDescription> propertySet = new ArrayList<PropertyDescription>();
        propertySet.add(new PropertyDescription("agentOptions", "Agent(s)", "AgentOptions", -1, false));
        propertySet.add(new PropertyDescription("forever", "Forever", "Boolean", 0, false));
        propertySet.add(new PropertyDescription("wrapSource", "Commands", "Commands", 0, true));
        propertySet.add(new PropertyDescription("name", "Display name", "String", 0, false));
        propertySet.add(new PropertyDescription("actionKey", "Action key", "Key", 0, false));
        return propertySet;
    }

    public Options<Class<? extends Agent>> agentOptions() {
        return this.agentOptions;
    }

    public void running(boolean running) {
        this.running = running;
    }

    public boolean running() {
        return this.running;
    }

    public boolean stopping() {
        return this.stopping;
    }

    public void stopping(boolean stopping) {
        this.stopping = stopping;
    }

    @Override
    public boolean isButton() {
        return true;
    }

    @Override
    public boolean isTurtleForeverButton() {
        return this.agentClass() == Turtle.class && this.forever();
    }

    @Override
    public boolean isLinkForeverButton() {
        return this.agentClass() == Link.class && this.forever();
    }

    public void name(String name) {
        this.name = name;
        this.chooseDisplayName();
    }

    public String name() {
        return this.name;
    }

    @Override
    public void agentClass(Class<? extends Agent> agentClass) {
        super.agentClass(agentClass);
        this.agentOptions().selectValue(this.agentClass());
        this.repaint();
    }

    public void action() {
        if (this.error != null) {
            return;
        }
        if (this.forever() || !this.running()) {
            if (!this.forever() || this.running()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            if (this.forever() && this.running()) {
                this.foreverOn = true;
                this.buttonUp(false);
                this.stopping(true);
            } else {
                this.stopping(false);
                this.running(true);
            }
            if (this.forever() && this.buttonUp()) {
                new Events.RemoveJobEvent(this).raise(this);
            } else if (this.forever() && !this.buttonUp() && this.stopping()) {
                new Events.JobStoppingEvent(this).raise(this);
            } else {
                new Events.AddJobEvent(this, this.agents(), this.procedure()).raise(this);
                if (Version.isLoggingEnabled()) {
                    Logger.logButtonPressed(this.displayName());
                }
            }
        }
    }

    @Override
    public void handle(Events.JobRemovedEvent e) {
        if (e.owner == this) {
            if (Version.isLoggingEnabled()) {
                Logger.logButtonStopped(this.displayName(), this.buttonUp, this.stopping);
            }
            this.popUpStoppingButton();
        }
    }

    public void popUpStoppingButton() {
        this.buttonUp(true);
        this.running(false);
        this.stopping(false);
        this.repaint();
        this.setCursor(null);
    }

    private void chooseDisplayName() {
        if (this.name().equals("")) {
            this.displayName(this.getSourceName());
        } else {
            this.displayName(this.name());
        }
    }

    private String getSourceName() {
        return this.innerSource.trim().replaceAll("\\s+", " ");
    }

    @Override
    public void innerSource(String innerSource) {
        super.innerSource(innerSource);
        this.chooseDisplayName();
    }

    public void wrapSource(String innerSource) {
        if (!innerSource.equals("") && innerSource.equals(this.innerSource())) {
            return;
        }
        this.innerSource(innerSource);
        this.recompile();
    }

    private void recompile() {
        String string = "to __button [] ";
        Class<? extends Agent> clazz = this.agentClass();
        if (null != clazz) {
            if (Observer.class.equals((Object)this.agentClass)) {
                string = string + " __observercode ";
            }
            if (Turtle.class.equals((Object)this.agentClass)) {
                string = string + " __turtlecode ";
            }
            if (Patch.class.equals((Object)this.agentClass)) {
                string = string + " __patchcode ";
            }
            if (Link.class.equals((Object)this.agentClass)) {
                string = string + "__linkcode ";
            }
            if (this.forever()) {
                string = string + " loop [ ";
            }
        }
        String string2 = "\n";
        if (null != clazz) {
            string2 = this.forever() ? string2 + "__foreverbuttonend ] " : string2 + "__done ";
            string2 = string2 + "end";
        }
        new Events.RemoveJobEvent(this).raise(this);
        this.source(string, this.innerSource, string2);
        this.chooseDisplayName();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(55, 33);
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        Dimension size = this.getMinimumSize();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        size.width = StrictMath.max(size.width, fontMetrics.stringWidth(this.displayName()) + 28);
        size.height = StrictMath.max(size.height, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 12);
        return size;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean drawAsUp = this.buttonUp() && !this.running();
        g.setColor(drawAsUp ? this.getBackground() : this.getForeground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Dimension size = this.getSize();
        FontMetrics fontMetrics = g.getFontMetrics();
        int labelHeight = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        this.renderImages(g, !drawAsUp);
        String displayName = this.displayName();
        int availableWidth = size.width - 8;
        int stringWidth = fontMetrics.stringWidth(displayName);
        g.setColor(drawAsUp ? this.getForeground() : this.getBackground());
        String shortString = Utils.shortenStringToFit(displayName, availableWidth, fontMetrics);
        int nx = stringWidth > availableWidth ? 4 : size.width / 2 - stringWidth / 2;
        int ny = size.height / 2 + labelHeight / 2;
        g.drawString(shortString, nx, ny);
        if (!this.actionKeyString().equals("")) {
            int ax = size.width - 4 - fontMetrics.stringWidth(this.actionKeyString());
            int ay = fontMetrics.getMaxAscent() + 2;
            if (drawAsUp) {
                g.setColor(this.keyEnabled ? Color.BLACK : Color.GRAY);
            } else {
                g.setColor(this.keyEnabled && this.forever() ? this.getBackground() : Color.BLACK);
            }
            g.drawString(this.actionKeyString(), ax - 1, ay);
        }
    }

    private void renderImages(Graphics graphics, boolean bl) {
        ImageIcon imageIcon = bl ? FOREVER_GRAPHIC_DARK : FOREVER_GRAPHIC;
        int n = 0;
        int n2 = 0;
        if (imageIcon != null) {
            n = imageIcon.getIconHeight();
            n2 = imageIcon.getIconWidth();
            if (this.forever()) {
                imageIcon.paintIcon(this, graphics, this.getWidth() - n2 - 4, this.getHeight() - n - 4);
            }
        }
        imageIcon = null;
        if (this.agentClass() == Turtle.class) {
            imageIcon = bl ? TURTLE_GRAPHIC_DARK : TURTLE_GRAPHIC;
        } else if (this.agentClass() == Patch.class) {
            imageIcon = bl ? PATCH_GRAPHIC_DARK : PATCH_GRAPHIC;
        } else if (this.agentClass() == Link.class) {
            ImageIcon imageIcon2 = imageIcon = bl ? LINK_GRAPHIC_DARK : LINK_GRAPHIC;
        }
        if (imageIcon != null) {
            n = imageIcon.getIconHeight();
            n2 = imageIcon.getIconWidth();
            imageIcon.paintIcon(this, graphics, 3, 3);
        }
    }

    @Override
    public Object load(String[] stringArray, Widget.LoadHelper loadHelper) {
        String string;
        String string2;
        String string3 = stringArray[7];
        this.forever(string3.equals("T"));
        this.agentClass(Observer.class);
        if (10 < stringArray.length && !(string2 = stringArray[10]).equals("NIL")) {
            if (string2.equals("TURTLE")) {
                this.agentClass(Turtle.class);
            } else if (string2.equals("PATCH")) {
                this.agentClass(Patch.class);
            } else if (string2.equals("LINK")) {
                this.agentClass(Link.class);
            }
        }
        if (stringArray.length > 12 && !stringArray[12].equals("NIL")) {
            this.actionKey(stringArray[12].charAt(0));
        }
        this.name("");
        string2 = stringArray[5];
        if (!string2.equals("NIL")) {
            this.name(string2);
        }
        if ((string = File.restoreLines(stringArray[6])).equals("NIL")) {
            string = "";
        }
        this.wrapSource(loadHelper.convert(string, false));
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        int n3 = Integer.parseInt(stringArray[3]);
        int n4 = Integer.parseInt(stringArray[4]);
        this.setSize(n3 - n, n4 - n2);
        this.chooseDisplayName();
        return this;
    }
}

