/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.shape.VectorShape;
import org.nlogo.swing.ColorSwatch;
import org.nlogo.swing.Utils;

public strictfp class ColorDialog
extends JDialog
implements ClipboardOwner,
ActionListener,
ItemListener,
MouseListener,
WindowListener {
    private double step = 1.0;
    private boolean numberVisibilityFlag = false;
    private boolean pointOneStepflag = false;
    private final NumberFormat formatter = new DecimalFormat("###.####");
    private int okCancelFlag = 0;
    private boolean plotPenMode = false;
    private JButton okButton;
    private Color selectedColor;
    private double selectedColorNumber;
    private String selectedColorName;
    private final Container pane;
    private final ButtonGroup swatchesGroup = new ButtonGroup();
    private final Container swatchesContainer = new Container();
    private final Container leftNameContainer = new Container();
    private final Container topNameContainer = new Container();
    private final Container rightPreviewContainer = new Container();
    private JRadioButton oneStep;
    private JRadioButton pointFiveStep;
    private JRadioButton pointOneStep;
    private ImageIcon turtleIcon;
    private JCheckBox checkboxHideNumbers;
    private JLabel selectedColorLabel;
    private JLabel[] turtleLabel = new JLabel[16];

    public ColorDialog(Frame frame, boolean modalFlag) {
        super(frame, "Color Swatches", modalFlag);
        this.setVisible(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(600, 400);
        this.setDefaultCloseOperation(1);
        this.pane = this.getContentPane();
        this.turtleIcon = this.getShapeIcon(0.0);
        this.addWindowListener(this);
        this.createLeftNames();
        this.createTopNames(this.turtleIcon);
        this.createRightPreview(this.turtleIcon);
        this.createTopLeftLabel();
        this.createSwatches();
        Utils.addEscKeyAction(this, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ColorDialog.this.setVisible(false);
                ColorDialog.this.dispose();
            }
        });
    }

    public double showInputBoxDialog(double initialColor) {
        this.plotPenMode = true;
        this.createControls(this.plotPenMode);
        this.selectSwatch(org.nlogo.api.Color.getColor(initialColor));
        this.setVisible(true);
        if (this.okCancelFlag == 1) {
            return this.selectedColorNumber;
        }
        return initialColor;
    }

    private void selectSwatch(Color initialColor) {
        double closest = org.nlogo.api.Color.getClosestColorNumberByARGB(initialColor.getRGB());
        Color closestColor = new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(closest));
        if (closest % 1.0 == 0.0 || closest >= 9.9) {
            this.oneStep.doClick();
        } else if (closest % 5.0 == 0.0) {
            this.pointOneStep.doClick();
        } else {
            this.pointFiveStep.doClick();
        }
        Enumeration<AbstractButton> e = this.swatchesGroup.getElements();
        while (e.hasMoreElements()) {
            JToggleButton swatch = (JToggleButton)e.nextElement();
            Color color = swatch.getBackground();
            if (!closestColor.equals(color)) continue;
            swatch.doClick();
        }
    }

    private void createTopNames(ImageIcon turtleIcon) {
        this.topNameContainer.setLayout(new GridLayout());
        Container blackButtonContainer = new Container();
        blackButtonContainer.setLayout(new GridLayout(1, 3));
        this.turtleLabel[14] = new JLabel(turtleIcon, 0);
        this.turtleLabel[14].setPreferredSize(new Dimension(60, 20));
        this.turtleLabel[14].setBackground(new Color(0, 0, 0));
        this.turtleLabel[14].setOpaque(true);
        blackButtonContainer.add(this.turtleLabel[14]);
        JToggleButton blackName = new JToggleButton(org.nlogo.api.Color.getColorNameByIndex(14) + " = 0");
        blackName.addActionListener(this);
        blackName.setActionCommand("0.0");
        blackName.setOpaque(true);
        blackName.setFont(new Font("ArialNarrow", 0, 10));
        Insets insets = new Insets(0, 0, 0, 0);
        blackName.setMargin(insets);
        this.swatchesGroup.add(blackName);
        blackButtonContainer.add(blackName);
        blackButtonContainer.add(new JLabel(""));
        this.topNameContainer.add(blackButtonContainer);
        Container whiteButtonContainer = new Container();
        whiteButtonContainer.setLayout(new GridLayout(1, 3));
        whiteButtonContainer.add(new JLabel(""));
        JToggleButton whiteName = new JToggleButton(org.nlogo.api.Color.getColorNameByIndex(15) + " = 9.9");
        whiteName.addActionListener(this);
        whiteName.setActionCommand("9.9");
        whiteName.setOpaque(true);
        whiteName.setFont(new Font("ArialNarrow", 0, 10));
        whiteName.setMargin(insets);
        this.swatchesGroup.add(whiteName);
        whiteButtonContainer.add(whiteName);
        this.turtleLabel[15] = new JLabel(turtleIcon, 0);
        this.turtleLabel[15].setPreferredSize(new Dimension(60, 20));
        this.turtleLabel[15].setBackground(new Color(255, 255, 255));
        this.turtleLabel[15].setOpaque(true);
        whiteButtonContainer.add(this.turtleLabel[15]);
        this.topNameContainer.add(whiteButtonContainer);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        this.pane.add((Component)this.topNameContainer, c);
        this.getContentPane().validate();
    }

    private void createLeftNames() {
        this.leftNameContainer.setLayout(new GridLayout(14, 1));
        for (int i = 5; i < 140; i += 10) {
            String colorNameString = org.nlogo.api.Color.getColorNameByIndex(i / 10) + " = " + i;
            JToggleButton colorName = new JToggleButton(colorNameString);
            colorName.addActionListener(this);
            colorName.setActionCommand(String.valueOf(i));
            colorName.setFont(new Font("ArialNarrow", 0, 10));
            this.swatchesGroup.add(colorName);
            this.leftNameContainer.add(colorName);
        }
        this.getContentPane().invalidate();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 3;
        c.insets = new Insets(5, 0, 0, 0);
        this.pane.add((Component)this.leftNameContainer, c);
    }

    private void createRightPreview(ImageIcon turtleIcon) {
        this.rightPreviewContainer.setLayout(new GridLayout(14, 1));
        int turtleIconindex = 0;
        for (int i = 5; i < 140; i += 10) {
            this.turtleLabel[turtleIconindex] = new JLabel(turtleIcon, 0);
            this.turtleLabel[turtleIconindex].setBackground(new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(i)));
            this.turtleLabel[turtleIconindex].setOpaque(true);
            this.rightPreviewContainer.add(this.turtleLabel[turtleIconindex]);
            ++turtleIconindex;
        }
        this.getContentPane().invalidate();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.pane.add((Component)this.rightPreviewContainer, c);
    }

    private void createTopLeftLabel() {
        JLabel upperLeftCorner = new JLabel("Preview");
        upperLeftCorner.setFont(new Font("ArialNarrow", 0, 10));
        upperLeftCorner.setPreferredSize(new Dimension(45, 20));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 2, 0, 0);
        this.pane.add((Component)upperLeftCorner, c);
    }

    private void createSwatches() {
        int rows = 14;
        double colorNumber = 0.0;
        int columnlength = 10;
        int swatchPerRow = (int)StrictMath.round((double)columnlength / this.step);
        this.swatchesContainer.invalidate();
        this.swatchesContainer.setLayout(new GridLayout(14, swatchPerRow));
        for (int i = 0; i < 14; ++i) {
            colorNumber = i * 10;
            for (int j = 0; j < swatchPerRow + 1; ++j) {
                JToggleButton swatch = new JToggleButton();
                if (j >= swatchPerRow) {
                    colorNumber = (double)(i * 10) + 9.9;
                } else {
                    swatch.setForeground(Color.BLACK);
                }
                swatch.setRolloverEnabled(true);
                swatch.setBorderPainted(true);
                swatch.setOpaque(true);
                swatch.setFocusPainted(false);
                swatch.setBorder(BorderFactory.createEmptyBorder());
                Color c = new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(colorNumber));
                swatch.setBackground(c);
                ColorSwatch s = new ColorSwatch(swatch.getPreferredSize().width, swatch.getPreferredSize().height);
                s.setBackground(c);
                if (!this.numberVisibilityFlag && !this.pointOneStepflag) {
                    JLabel label = new JLabel(this.formatter.format(colorNumber));
                    label.setFont(new Font("ArialNarrow", 0, 8));
                    if (colorNumber % 10.0 < 3.5) {
                        label.setForeground(Color.LIGHT_GRAY);
                    }
                    s.add(label);
                }
                swatch.add(s);
                swatch.setActionCommand(String.valueOf(colorNumber));
                swatch.addActionListener(this);
                swatch.addMouseListener(this);
                this.swatchesGroup.add(swatch);
                this.swatchesContainer.add(swatch);
                colorNumber = this.step + colorNumber;
            }
        }
        this.swatchesContainer.validate();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(5, 5, 0, 2);
        this.pane.add((Component)this.swatchesContainer, c);
    }

    private void createControls(boolean plotPenFlag) {
        Container controlsContainer = new Container();
        controlsContainer.setLayout(new BoxLayout(controlsContainer, 2));
        if (!plotPenFlag) {
            JButton copyButton = new JButton("Copy selected color");
            copyButton.setActionCommand("Copy");
            copyButton.addActionListener(this);
            controlsContainer.add(copyButton);
        } else {
            controlsContainer.add(Box.createRigidArea(new Dimension(10, 0)));
            this.okButton = new JButton("OK");
            controlsContainer.add(this.okButton);
            this.okButton.addActionListener(this);
            controlsContainer.add(Box.createRigidArea(new Dimension(10, 0)));
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(this);
            controlsContainer.add(cancelButton);
            controlsContainer.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        this.selectedColorLabel = new JLabel(org.nlogo.api.Color.getColorNameByIndex(14));
        this.selectedColorLabel.setMinimumSize(new Dimension(100, 20));
        this.selectedColorLabel.setMaximumSize(new Dimension(100, 20));
        this.selectedColorLabel.setPreferredSize(new Dimension(100, 20));
        this.selectedColorLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        controlsContainer.add(this.selectedColorLabel);
        controlsContainer.add(Box.createHorizontalGlue());
        this.checkboxHideNumbers = new JCheckBox("Numbers", true);
        controlsContainer.add(this.checkboxHideNumbers);
        this.checkboxHideNumbers.addItemListener(this);
        controlsContainer.add(Box.createHorizontalGlue());
        JPanel stepJpanel = new JPanel();
        stepJpanel.setLayout(new BoxLayout(stepJpanel, 2));
        stepJpanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.oneStep = new JRadioButton("1");
        this.oneStep.setActionCommand("oneStep");
        stepJpanel.add(this.oneStep);
        this.oneStep.setSelected(true);
        this.pointFiveStep = new JRadioButton("0.5");
        this.pointFiveStep.setActionCommand("pointFiveStep");
        stepJpanel.add(this.pointFiveStep);
        this.pointOneStep = new JRadioButton("0.1");
        this.pointOneStep.setActionCommand("pointOneStep");
        stepJpanel.add(this.pointOneStep);
        ButtonGroup groupStep = new ButtonGroup();
        groupStep.add(this.oneStep);
        groupStep.add(this.pointFiveStep);
        groupStep.add(this.pointOneStep);
        this.oneStep.addActionListener(this);
        this.pointFiveStep.addActionListener(this);
        this.pointOneStep.addActionListener(this);
        controlsContainer.add(stepJpanel);
        JLabel gradationLabel = new JLabel(" Increment");
        controlsContainer.add(gradationLabel);
        controlsContainer.add(Box.createRigidArea(new Dimension(10, 0)));
        controlsContainer.add(new JLabel("  "));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.gridwidth = 3;
        this.pane.add((Component)controlsContainer, c);
    }

    private ImageIcon getShapeIcon(double colorValue) {
        VectorShape defaultShape = VectorShape.getDefaultShape();
        BufferedImage image = new BufferedImage(16, 16, 2);
        Graphics2DWrapper g2 = new Graphics2DWrapper(image.createGraphics());
        g2.antiAliasing(true);
        defaultShape.paint(g2, new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(colorValue)), 0, 0, 16.0, 0);
        g2.drawImage(image);
        return new ImageIcon(image);
    }

    private boolean isNumber(String n) {
        try {
            Double.valueOf(n).doubleValue();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (this.isNumber(actionCommand)) {
            this.selectedColorNumber = Double.valueOf(e.getActionCommand());
            this.selectedColor = new Color(org.nlogo.api.Color.getARGBbyPremodulatedColorNumber(this.selectedColorNumber));
            this.selectedColorName = org.nlogo.api.Color.getClosestColorNameByARGB(this.selectedColor.getRGB());
            this.selectedColorLabel.setText(this.selectedColorName);
            this.turtleIcon = this.getShapeIcon(this.selectedColorNumber);
            for (int i = 0; i <= 15; ++i) {
                this.turtleLabel[i].setIcon(this.turtleIcon);
            }
        } else if (actionCommand.equals("Copy")) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            StringSelection st = new StringSelection(this.selectedColorName);
            Clipboard cp = tk.getSystemClipboard();
            cp.setContents(st, this);
        } else if (actionCommand.endsWith("Step")) {
            if (actionCommand.equals("oneStep")) {
                this.step = 1.0;
                this.pointOneStepflag = false;
                this.checkboxHideNumbers.setEnabled(true);
            } else if (actionCommand.equals("pointFiveStep")) {
                this.step = 0.5;
                this.pointOneStepflag = false;
                this.checkboxHideNumbers.setEnabled(true);
            } else if (actionCommand.equals("pointOneStep")) {
                this.step = 0.1;
                this.pointOneStepflag = true;
                this.checkboxHideNumbers.setEnabled(false);
            }
            this.swatchesContainer.setVisible(false);
            this.swatchesContainer.removeAll();
            this.createSwatches();
            this.swatchesContainer.setVisible(true);
            this.swatchesContainer.repaint();
        } else if (actionCommand.equals("OK")) {
            this.okCancelFlag = 1;
            this.dispose();
        } else if (actionCommand.equals("Cancel")) {
            this.okCancelFlag = -1;
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.numberVisibilityFlag = false;
        } else if (e.getStateChange() == 2) {
            this.numberVisibilityFlag = true;
        }
        this.swatchesContainer.removeAll();
        this.createSwatches();
    }

    public void mouseEntered(MouseEvent e) {
        JToggleButton selectedSwatch = (JToggleButton)e.getSource();
        selectedSwatch.setBorder(BorderFactory.createLineBorder(Color.gray));
        if ((e.getModifiers() & 0x1F5) == 16) {
            selectedSwatch.doClick();
        }
    }

    public void mouseExited(MouseEvent e) {
        JToggleButton selectedSwatch = (JToggleButton)e.getSource();
        selectedSwatch.setSelected(false);
        selectedSwatch.setBorder(BorderFactory.createEmptyBorder());
    }

    public void windowClosing(WindowEvent e) {
        if (this.plotPenMode) {
            this.okCancelFlag = 1;
            this.okButton.doClick();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void lostOwnership(Clipboard clip, Transferable tr) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }
}

