/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.BooleanConstraint;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Observer;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.CommandRunnable;
import org.nlogo.api.CompilerException;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.File;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.ModelReader;
import org.nlogo.api.Perspective;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.ReporterRunnable;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.awt.MovieEncoder;
import org.nlogo.awt.UserCancelException;
import org.nlogo.awt.Utils;
import org.nlogo.nvm.CompilerInterface;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.SliderJobOwner;
import org.nlogo.nvm.Workspace;
import org.nlogo.plot.Plot;
import org.nlogo.shape.InvalidShapeDescriptionException;
import org.nlogo.shape.LinkShape;
import org.nlogo.shape.VectorShape;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.window.AppEventType;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.ExternalFileManager;
import org.nlogo.window.GLViewManagerInterface;
import org.nlogo.window.JOGLLoadingException;
import org.nlogo.window.JobWidget;
import org.nlogo.window.LocalViewInterface;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.PeriodicUpdater;
import org.nlogo.window.PlotWidget;
import org.nlogo.window.RuntimeErrorDialog;
import org.nlogo.window.ThreadUtils;
import org.nlogo.window.UpdateManager;
import org.nlogo.window.View;
import org.nlogo.window.ViewManager;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.workspace.AbstractWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class GUIWorkspace
extends AbstractWorkspace
implements DrawingInterface,
TrailDrawerInterface,
Event.LinkChild,
Events.AboutToQuitEvent.Handler,
Events.AddBooleanConstraintEvent.Handler,
Events.AddChooserConstraintEvent.Handler,
Events.AddInputBoxConstraintEvent.Handler,
Events.AddJobEvent.Handler,
Events.AddSliderConstraintEvent.Handler,
Events.AfterLoadEvent.Handler,
Events.BeforeLoadEvent.Handler,
Events.CompiledEvent.Handler,
Events.ExportPlotEvent.Handler,
Events.JobStoppingEvent.Handler,
Events.LoadSectionEvent.Handler,
Events.RemoveAllJobsEvent.Handler,
Events.RemoveConstraintEvent.Handler,
Events.RemoveJobEvent.Handler {
    public final KioskLevel kioskLevel;
    private final Frame frame;
    private final Component linkParent;
    public final ViewWidget viewWidget;
    public final View view;
    final UpdateManager updateManager;
    private WidgetContainer widgetContainer = null;
    public GLViewManagerInterface glView = null;
    public ViewManager viewManager = new ViewManager();
    private final ExternalFileManager externalFileManager;
    public MovieEncoder movieEncoder = null;
    private final CompilerInterface compiler;
    private boolean snapOn = false;
    private boolean dualView;
    private final Runnable updateRunner = new Runnable(){

        public void run() {
            new Events.PeriodicUpdateEvent().raise(GUIWorkspace.this);
        }
    };
    private boolean periodicUpdatesEnabled = false;
    public final Action hubNetControlCenterAction = new AbstractAction("HubNet Control Center"){

        public void actionPerformed(ActionEvent e) {
            GUIWorkspace.this.hubNetManager.showControlCenter();
        }
    };
    public final Action switchTo3DViewAction = new AbstractAction("3D View"){

        public void actionPerformed(ActionEvent e) {
            GUIWorkspace.this.open3DView();
        }
    };

    @Override
    public CompilerInterface compiler() {
        return this.compiler;
    }

    public GUIWorkspace(final World world, KioskLevel kioskLevel, Frame frame, Component linkParent, AbstractWorkspace.HubNetManagerFactory hubNetManagerFactory, ExternalFileManager externalFileManager, CompilerInterface compiler) {
        super(world, hubNetManagerFactory);
        this.kioskLevel = kioskLevel;
        this.frame = frame;
        this.linkParent = linkParent;
        this.externalFileManager = externalFileManager;
        this.compiler = compiler;
        this.hubNetControlCenterAction.setEnabled(false);
        this.updateManager = new UpdateManager(this);
        this.viewWidget = new ViewWidget(this);
        this.view = this.viewWidget.view;
        this.viewManager.setPrimary(this.view);
        PeriodicUpdater periodicUpdater = new PeriodicUpdater(this.jobManager);
        periodicUpdater.start();
        world.trailDrawer(this);
        AbstractAction repaintAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (world.displayOn() && GUIWorkspace.this.displaySwitchOn() && !GUIWorkspace.this.jobManager.anyPrimaryJobs()) {
                    GUIWorkspace.this.viewManager.paintImmediately(world.observer().updatePosition());
                }
            }
        };
        new Timer(100, repaintAction).start();
        new Thread("Lifeguard"){

            public void run() {
                try {
                    while (true) {
                        if (GUIWorkspace.this.jobManager.anyPrimaryJobs()) {
                            world.comeUpForAir = true;
                        }
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException ex) {
                    Exceptions.ignore(ex);
                    return;
                }
            }
        }.start();
    }

    public abstract RendererInterface newRenderer();

    @Override
    public void stamp(Agent agent, boolean erase) {
        this.view.renderer.prepareToPaint(this.view, this.view.renderer.trailDrawer().getWidth(), this.view.renderer.trailDrawer().getHeight());
        this.view.renderer.trailDrawer().stamp(agent, erase);
        if (this.hubNetManager != null) {
            this.hubNetManager.sendStamp(agent, erase);
        }
    }

    @Override
    public void importDrawing(File file) throws IOException {
        this.view.renderer.trailDrawer().importDrawing(file);
    }

    @Override
    public void exportDrawing(String filename, String format) throws IOException {
        FileOutputStream stream = new FileOutputStream(new java.io.File(filename));
        ImageIO.write((RenderedImage)this.view.renderer.trailDrawer().getAndCreateDrawing(true), format, stream);
        stream.close();
    }

    @Override
    public BufferedImage getAndCreateDrawing() {
        return this.getAndCreateDrawing(true);
    }

    @Override
    public BufferedImage getAndCreateDrawing(boolean dirty) {
        return this.view.renderer.trailDrawer().getAndCreateDrawing(dirty);
    }

    @Override
    public void clearDrawing() {
        this.world.clearDrawing();
        this.view.renderer.trailDrawer().clearDrawing();
        if (this.hubNetManager != null) {
            this.hubNetManager.sendClear();
        }
    }

    @Override
    public boolean sendPixels() {
        return this.view.renderer.trailDrawer().sendPixels();
    }

    @Override
    public void sendPixels(boolean dirty) {
        this.view.renderer.trailDrawer().sendPixels(dirty);
    }

    public void setWidgetContainer(WidgetContainer widgetContainer) {
        this.widgetContainer = widgetContainer;
    }

    public boolean isHeadless() {
        return false;
    }

    @Override
    public void waitFor(CommandRunnable runnable) throws LogoException {
        ThreadUtils.waitFor(this, runnable);
    }

    @Override
    public <T> T waitForResult(ReporterRunnable<T> runnable) throws LogoException {
        return ThreadUtils.waitForResult(this, runnable);
    }

    @Override
    public void waitForQueuedEvents() throws LogoException {
        ThreadUtils.waitForQueuedEvents(this);
    }

    @Override
    public Object getLinkParent() {
        return this.linkParent;
    }

    @Override
    public boolean warningMessage(String message) {
        Object[] options = new String[]{"Continue", "Cancel"};
        message = "Warning: " + message;
        switch (OptionDialog.show(this.getFrame(), "Warning", message, options)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void resizeView() {
        Utils.mustBeEventDispatchThread();
        this.viewWidget.settings().resizeWithProgress(true);
    }

    @Override
    public void patchSize(double patchSize) {
        this.viewWidget.settings().patchSize(patchSize);
    }

    @Override
    public double patchSize() {
        return this.world.patchSize();
    }

    @Override
    public void setDimensions(final WorldDimensions d) {
        Runnable runner = new Runnable(){

            public void run() {
                GUIWorkspace.this.viewWidget.settings().setDimensions(d);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runner.run();
        } else {
            try {
                Utils.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
                Exceptions.handle(ex);
            }
        }
    }

    @Override
    public void setDimensions(final WorldDimensions d, final double patchSize) {
        Runnable runner = new Runnable(){

            public void run() {
                GUIWorkspace.this.viewWidget.settings().setDimensions(d, patchSize);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runner.run();
        } else {
            try {
                Utils.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
                Exceptions.handle(ex);
            }
        }
    }

    public void patchesCreatedNotify() {
        new Events.PatchesCreatedEvent().raise(this);
    }

    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public WorldPropertiesInterface getPropertiesInterface() {
        return this.viewWidget.settings();
    }

    @Override
    public void changeTopology(boolean wrapX, boolean wrapY) {
        this.world.changeTopology(wrapX, wrapY);
        this.viewWidget.view.renderer.changeTopology(wrapX, wrapY);
    }

    @Override
    public void openIndex() {
        new Events.AppEvent(AppEventType.OPEN_INDEX, new Object[0]).raiseLater(this);
    }

    @Override
    public void openNext() {
        new Events.AppEvent(AppEventType.OPEN_NEXT, new Object[0]).raiseLater(this);
    }

    @Override
    public void openPrevious() {
        new Events.AppEvent(AppEventType.OPEN_PREVIOUS, new Object[0]).raiseLater(this);
    }

    public void reload() {
        new Events.AppEvent(AppEventType.RELOAD, new Object[0]).raiseLater(this);
    }

    @Override
    public void magicOpen(String name) {
        new Events.AppEvent(AppEventType.MAGIC_OPEN, new Object[]{name}).raiseLater(this);
    }

    @Override
    public void zipLogFiles(String filename) {
        try {
            new Events.AppEvent(AppEventType.ZIP_LOG_FILES, new Object[]{this.fileManager.attachPrefix(filename)}).raiseLater(this);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void deleteLogFiles() {
        new Events.AppEvent(AppEventType.DELETE_LOG_FILES, new Object[0]).raiseLater(this);
    }

    public boolean displaySwitchOn() {
        return this.viewManager.getPrimary().displaySwitch();
    }

    public void displaySwitchOn(boolean on) {
        this.viewManager.getPrimary().displaySwitch(on);
    }

    public void set2DViewEnabled(boolean enabled) {
        if (enabled) {
            this.displaySwitchOn(this.glView.displayOn());
            this.viewManager.setPrimary(this.view);
            this.viewManager.remove(this.glView);
            this.view.dirty();
            if (this.glView.displayOn()) {
                this.view.thaw();
            }
            if (this.world.observer().perspective() != Perspective.FOLLOW && this.world.observer().perspective() != Perspective.RIDE) {
                this.world.observer().home();
            }
            this.viewWidget.setVisible(true);
            try {
                this.viewWidget.displaySwitch.setOn(this.glView.displaySwitch());
            }
            catch (IllegalStateException e) {
                Exceptions.ignore(e);
            }
        } else {
            this.viewManager.setPrimary(this.glView);
            if (!this.dualView) {
                this.viewManager.remove(this.view);
                this.view.freeze();
            }
            this.glView.displaySwitch(this.viewWidget.displaySwitch.isSelected());
            this.viewWidget.setVisible(this.dualView);
        }
        this.view.renderPerspective = enabled;
        this.viewWidget.settings().refreshViewProperties(!enabled);
        new Events.Enable2DEvent(enabled).raise(this);
    }

    public boolean mouseDown() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseDown();
    }

    public boolean mouseInside() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseInside();
    }

    public double mouseXCor() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseXCor();
    }

    public double mouseYCor() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseYCor();
    }

    @Override
    public void updateMode(Workspace.UpdateMode updateMode) {
        super.updateMode(updateMode);
        this.updateManager.updateTickGap();
    }

    public double speed() {
        double s = this.updateManager.speed() * 2.0;
        if (s > 0.0) {
            s += 10.0;
        } else if (s < 0.0) {
            s -= 10.0;
        }
        return s;
    }

    public void speed(double speed) {
        this.updateManager.speed(speed);
    }

    public void donePainting() {
        this.updateManager.donePainting();
    }

    @Override
    public void updateDisplay(boolean haveWorldLockAlready) {
        this.updateDisplay2(haveWorldLockAlready);
    }

    private boolean updateDisplay2(boolean haveWorldLockAlready) {
        this.view.dirty();
        if (!this.world.displayOn()) {
            return false;
        }
        if (!this.updateManager.enoughWhateverPassed()) {
            this.viewManager.framesSkipped();
            return true;
        }
        if (this.displaySwitchOn()) {
            if (haveWorldLockAlready) {
                try {
                    this.waitFor(new CommandRunnable(){

                        public void run() {
                            GUIWorkspace.this.viewManager.incrementalUpdateFromEventThread();
                        }
                    });
                }
                catch (HaltException ex) {
                    Exceptions.ignore(ex);
                }
                catch (LogoException ex) {
                    throw new IllegalStateException(ex);
                }
            } else {
                this.viewManager.incrementalUpdateFromJobThread();
            }
            this.updateManager.pauseAfterDisplayUpdate();
            return true;
        }
        return false;
    }

    public void forceDisplayAndTicksUpdates() {
        ThreadUtils.waitFor(this, this.updateRunner);
        this.updateManager.reset();
        this.requestDisplayUpdate(true);
    }

    public void setPeriodicUpdatesEnabled(boolean periodicUpdatesEnabled) {
        this.periodicUpdatesEnabled = periodicUpdatesEnabled;
    }

    @Override
    public void periodicUpdate() {
        if (this.periodicUpdatesEnabled) {
            ThreadUtils.waitFor(this, this.updateRunner);
        }
    }

    @Override
    public void requestDisplayUpdate(boolean force) {
        if (this.updateManager.speed() <= 0.0) {
            if (force) {
                this.updateManager.reset();
            }
            this.updateDisplay(true);
        } else {
            if (force) {
                this.updateManager.pseudoTick();
            }
            this.updateDisplay(true);
        }
    }

    @Override
    public void perhapsUpdateDisplay() {
        this.jobManager.maybeRunSecondaryJobs();
        switch (this.updateMode()) {
            case CONTINUOUS: {
                this.updateManager.pseudoTick();
                if (this.updateDisplay2(true) && !(this.updateManager.speed() >= 0.0)) break;
                this.world.comeUpForAir = false;
                break;
            }
            case TICK_BASED: {
                this.world.comeUpForAir = false;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void halt() {
        this.jobManager.interrupt();
        new ModalProgressTask(this.getFrame(), new Runnable(){

            public void run() {
                GUIWorkspace.super.halt();
                GUIWorkspace.this.view.dirty();
                GUIWorkspace.this.view.repaint();
            }
        }, "Halting...");
    }

    @Override
    public void handle(Events.AfterLoadEvent afterLoadEvent) {
        this.setPeriodicUpdatesEnabled(true);
        this.world.observer().resetPerspective();
        this.updateManager.reset();
        this.updateManager.speed(0.0);
        if (this.glView != null) {
            this.glView.close();
        }
        if (this.world.program().is3D) {
            this.open3DView();
        }
        try {
            this.evaluateCommands("without-interruption [ startup ]", Observer.class, false);
        }
        catch (CompilerException compilerException) {
            Exceptions.ignore(compilerException);
        }
    }

    private void open3DView() {
        try {
            this.glView.open();
            this.set2DViewEnabled(false);
        }
        catch (JOGLLoadingException jlex) {
            String message = jlex.getMessage();
            org.nlogo.swing.Utils.alert("3D View", message, "" + jlex.getCause());
            this.switchTo3DViewAction.setEnabled(false);
        }
    }

    public void addCustomShapes(String filename) throws IOException, InvalidShapeDescriptionException {
        try {
            this.glView.addCustomShapes(this.fileManager.attachPrefix(filename));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public int[] colors() {
        return this.view.renderer.trailDrawer().colors();
    }

    @Override
    public boolean isDirty() {
        return this.view.renderer.trailDrawer().isDirty();
    }

    @Override
    public boolean isBlank() {
        return this.view.renderer.trailDrawer().isBlank();
    }

    @Override
    public void markClean() {
        this.view.renderer.trailDrawer().markClean();
    }

    @Override
    public void markDirty() {
        this.view.renderer.trailDrawer().markDirty();
    }

    @Override
    public int getWidth() {
        return this.view.renderer.trailDrawer().getWidth();
    }

    @Override
    public int getHeight() {
        return this.view.renderer.trailDrawer().getHeight();
    }

    @Override
    public void readImage(InputStream is) throws IOException {
        this.view.renderer.trailDrawer().readImage(is);
    }

    @Override
    public void rescaleDrawing() {
        this.view.renderer.trailDrawer().rescaleDrawing();
    }

    @Override
    public void drawLine(double x0, double y0, double x1, double y1, Object color, double size, String mode) {
        this.view.renderer.trailDrawer().drawLine(x0, y0, x1, y1, color, size, mode);
        if (this.hubNetManager != null) {
            this.hubNetManager.sendLine(x0, y0, x1, y1, color, size, mode);
        }
    }

    @Override
    public void setColors(int[] colors) {
        this.view.renderer.trailDrawer().setColors(colors);
    }

    @Override
    public Object getDrawing() {
        return this.view.renderer.trailDrawer().getDrawing();
    }

    @Override
    public void ownerFinished(JobOwner owner) {
        new Events.JobRemovedEvent(owner).raiseLater(this);
        if (owner.ownsPrimaryJobs()) {
            this.updateManager.reset();
            this.updateDisplay(false);
        }
    }

    @Override
    public void handle(Events.AddJobEvent e) {
        JobWidget widget;
        JobOwner owner = e.owner;
        AgentSet agents = e.agents;
        if (owner instanceof JobWidget && agents == null && (widget = (JobWidget)owner).useAgentClass()) {
            agents = this.world.agentClassToAgentSet(widget.agentClass());
        }
        if (owner.ownsPrimaryJobs()) {
            if (e.procedure != null) {
                this.jobManager.addJob(owner, agents, e.procedure);
            } else {
                new Events.JobRemovedEvent(owner).raiseLater(this);
            }
        } else {
            this.jobManager.addSecondaryJob(owner, agents, e.procedure);
        }
    }

    @Override
    public void handle(Events.RemoveJobEvent e) {
        JobOwner owner = e.owner;
        if (owner.ownsPrimaryJobs()) {
            this.jobManager.finishJobs(owner);
        } else {
            this.jobManager.finishSecondaryJobs(owner);
        }
    }

    @Override
    public void handle(Events.JobStoppingEvent e) {
        this.jobManager.stoppingJobs(e.owner);
    }

    @Override
    public void handle(Events.RemoveAllJobsEvent e) {
        this.jobManager.haltSecondary();
        this.jobManager.haltPrimary();
    }

    @Override
    public void handle(Events.AddBooleanConstraintEvent e) {
        BooleanConstraint con = new BooleanConstraint(e.defaultValue);
        int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world.observer().variableConstraint(index, con);
        }
    }

    @Override
    public void handle(Events.AddInputBoxConstraintEvent e) {
        int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world.observer().variableConstraint(index, e.constraint);
        }
    }

    @Override
    public void handle(Events.AddChooserConstraintEvent e) {
        int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world.observer().variableConstraint(index, e.constraint);
        }
    }

    @Override
    public void handle(Events.AddSliderConstraintEvent e) {
        try {
            e.slider.setConstraintError(null, null);
            SliderConstraint con = SliderConstraint.makeSliderConstraint(this.world.observer(), e.minSpec, e.maxSpec, e.incSpec, e.value, new SliderJobOwner(e.slider.name(), this.world));
            e.slider.setSliderConstraint(con);
            int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
            if (index != -1) {
                this.world.observer().variableConstraint(index, con);
            }
        }
        catch (SliderConstraint.RuntimeConstraintException ex) {
            e.slider.setConstraintError(ex.constraint, ex);
            throw new IllegalStateException(ex);
        }
        catch (LogoException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SliderConstraint.ConstraintCompilerException ex) {
            e.slider.setConstraintError(ex.constraint, ex);
        }
    }

    @Override
    public void handle(Events.RemoveConstraintEvent e) {
        int index = this.world.observerOwnsIndexOf(e.varname.toUpperCase());
        if (index != -1) {
            this.world.observer().variableConstraint(index, null);
        }
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        this.codeBits.clear();
    }

    @Override
    public abstract void inspectAgent(Class<? extends org.nlogo.agent.Agent> var1, org.nlogo.agent.Agent var2, double var3);

    @Override
    public void clearOutput() {
        final Events.OutputEvent event = new Events.OutputEvent(true, null, false, false);
        if (!EventQueue.isDispatchThread()) {
            ThreadUtils.waitFor(this, new Runnable(){

                public void run() {
                    event.raise(GUIWorkspace.this);
                }
            });
        } else {
            event.raise(this);
        }
    }

    @Override
    protected void sendOutput(OutputObject oo, boolean toOutputArea) {
        final Events.OutputEvent event = new Events.OutputEvent(false, oo, false, !toOutputArea);
        if (!EventQueue.isDispatchThread()) {
            ThreadUtils.waitFor(this, new Runnable(){

                public void run() {
                    event.raise(GUIWorkspace.this);
                }
            });
        } else {
            event.raise(this);
        }
    }

    @Override
    protected Importer.ErrorHandler getImporterErrorHandler() {
        return new Importer.ErrorHandler(){

            public boolean showError(String title, String errorDetails, boolean fatalError) {
                Object[] objectArray;
                Utils.mustBeEventDispatchThread();
                if (fatalError) {
                    Object[] objectArray2 = new String[1];
                    objectArray = objectArray2;
                    objectArray2[0] = "OK";
                } else {
                    String[] stringArray = new String[2];
                    stringArray[0] = "Continue";
                    objectArray = stringArray;
                    stringArray[1] = "Cancel";
                }
                Object[] options = objectArray;
                return OptionDialog.show(GUIWorkspace.this.getFrame(), title, errorDetails, options) == 0;
            }
        };
    }

    public Component getExportWindowFrame() {
        return this.viewManager.getPrimary().getExportWindowFrame();
    }

    public BufferedImage exportView() {
        return this.viewManager.getPrimary().exportView();
    }

    @Override
    public void exportView(String filename, String format) throws IOException {
        this.exportView(this.viewManager.getPrimary(), filename, format);
    }

    public void exportView(LocalViewInterface display, String filename, String format) throws IOException {
        FileOutputStream stream = new FileOutputStream(new java.io.File(filename));
        ImageIO.write((RenderedImage)display.exportView(), format, stream);
        stream.close();
    }

    public void doExportView(final LocalViewInterface localViewInterface) {
        try {
            final String string = FileDialog.show(this.getExportWindowFrame(), "Export View", 1, this.guessExportName("view.png"));
            final IOException[] iOExceptionArray = new IOException[]{null};
            new ModalProgressTask(this.getFrame(), new Runnable(){

                public void run() {
                    try {
                        GUIWorkspace.this.exportView(localViewInterface, string, "png");
                    }
                    catch (IOException ex) {
                        iOExceptionArray[0] = ex;
                    }
                }
            }, "Exporting...");
            if (iOExceptionArray[0] != null) {
                throw iOExceptionArray[0];
            }
        }
        catch (UserCancelException userCancelException) {
            Exceptions.ignore(userCancelException);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getExportWindowFrame(), iOException.getMessage(), "Error", 0);
        }
    }

    @Override
    public void exportInterface(String filename) throws IOException {
        FileOutputStream stream = new FileOutputStream(new java.io.File(filename));
        IOException[] exceptionBox = new IOException[1];
        new Events.ExportInterfaceEvent(stream, exceptionBox).raise(this);
        stream.close();
        if (exceptionBox[0] != null) {
            throw exceptionBox[0];
        }
    }

    @Override
    public void exportOutput(String filename) {
        new Events.ExportOutputEvent(filename).raise(this);
    }

    @Override
    public void exportDrawingToCSV(PrintWriter writer) {
        this.view.renderer.trailDrawer().exportDrawingToCSV(writer);
    }

    @Override
    public void exportOutputAreaToCSV(PrintWriter writer) {
        new Events.ExportWorldEvent(writer).raise(this);
    }

    @Override
    public void handle(Events.ExportPlotEvent exportPlotEvent) {
        if (exportPlotEvent.whichPlots == PlotWidget.ExportType.ALL) {
            if (this.plotManager().getPlotNames().length == 0) {
                OptionDialog.show(this.getFrame(), "Export Plot", "There are no plots to export.", new String[]{"OK"});
                return;
            }
            try {
                super.exportAllPlots(exportPlotEvent.filename);
            }
            catch (IOException iOException) {
                String string = "Export of all plots to" + exportPlotEvent.filename + " failed: " + iOException.getMessage();
                Object[] objectArray = new String[]{"OK"};
                OptionDialog.show(this.getFrame(), "Export Plot Failed", string, objectArray);
            }
        } else {
            Plot plot = exportPlotEvent.plot;
            if (plot == null) {
                plot = this.choosePlot(this.getFrame());
            }
            if (plot != null) {
                try {
                    super.exportPlot(plot.name(), exportPlotEvent.filename);
                }
                catch (IOException iOException) {
                    String string = "Export of " + plot.name() + " plot to " + exportPlotEvent.filename + " failed: " + iOException.getMessage();
                    Object[] objectArray = new String[]{"OK"};
                    OptionDialog.show(this.getFrame(), "Export Plot Failed", string, objectArray);
                }
            }
        }
    }

    Plot choosePlot(Frame frame) {
        Object[] objectArray = this.plotManager().getPlotNames();
        if (objectArray.length == 0) {
            String string = "There are no plots to export.";
            Object[] objectArray2 = new String[]{"OK"};
            OptionDialog.show(frame, "Export Plot", string, objectArray2);
            return null;
        }
        String string = "Which plot would you like to export?";
        int n = OptionDialog.showAsList(frame, "Export Plot", string, objectArray);
        if (n < 0) {
            return null;
        }
        return this.plotManager().getPlot((String)objectArray[n]);
    }

    @Override
    public void runtimeError(final JobOwner owner, final Context context, final Instruction instruction, final Exception ex) {
        final Thread thread = Thread.currentThread();
        Utils.invokeLater(new Runnable(){

            public void run() {
                GUIWorkspace.this.runtimeErrorPrivate(owner, context, instruction, thread, ex);
            }
        });
    }

    private void runtimeErrorPrivate(JobOwner owner, final Context context, final Instruction instruction, final Thread thread, final Exception ex) {
        if (ex instanceof HaltException && ((HaltException)ex).haltAll) {
            this.halt();
        } else if (!(owner instanceof MonitorWidget)) {
            this.world.displayOn(true);
        }
        if (owner != null && !(ex instanceof HaltException)) {
            SourceOwner sourceOwner = context.activation.procedure.owner;
            int[] posAndLength = instruction.token() == null ? new int[]{-1, 0} : instruction.getPositionAndLength();
            new Events.RuntimeErrorEvent(owner, sourceOwner, posAndLength[0], posAndLength[1]).raiseLater(this);
        }
        if (!(owner instanceof MonitorWidget) && !(ex instanceof HaltException)) {
            Utils.invokeLater(new Runnable(){

                public void run() {
                    RuntimeErrorDialog.show("Runtime Error", context, instruction, thread, ex);
                }
            });
        }
    }

    @Override
    public void handle(Events.BeforeLoadEvent beforeLoadEvent) {
        this.setPeriodicUpdatesEnabled(false);
        if (!GUIWorkspace.isApplet()) {
            this.setModelPath(beforeLoadEvent.modelPath);
            this.setModelType(beforeLoadEvent.modelType);
        }
        if (this.hubNetManager != null && this.hubNetManager.connectionsExist()) {
            this.hubNetManager.disconnect();
        }
        this.getExtensionManager().reset();
        this.fileManager.handleModelChange();
        this.previewCommands = "setup repeat 75 [ go ]";
        this.clearDrawing();
        this.viewManager.resetMouseCors();
        this.displaySwitchOn(true);
    }

    @Override
    public void handle(Events.AboutToQuitEvent e) {
        if (this.hubNetManager != null && this.hubNetManager.connectionsExist()) {
            this.hubNetManager.disconnect();
        }
    }

    @Override
    public void computerHubNetRunning(boolean computerHubNetRunning) {
        if (this.computerHubNetRunning != computerHubNetRunning) {
            if (computerHubNetRunning) {
                this.viewManager.add(this.hubNetManager);
            } else {
                this.viewManager.remove(this.hubNetManager);
            }
        }
        this.computerHubNetRunning = computerHubNetRunning;
        this.hubNetControlCenterAction.setEnabled(computerHubNetRunning);
    }

    @Override
    public void handle(Events.LoadSectionEvent e) {
        if (e.section == ModelReader.Section.PREVIEW_COMMANDS && e.text.trim().length() > 0) {
            this.previewCommands = e.text;
        }
        if (e.section == ModelReader.Section.CLIENT && e.lines.length > 0 && !GUIWorkspace.isApplet()) {
            this.getHubNetManager().load(e.lines, e.version);
        }
        if (e.section == ModelReader.Section.SHAPES) {
            this.world.turtleShapeList().replaceShapes(VectorShape.parseShapes(e.lines, e.version));
        }
        if (e.section == ModelReader.Section.LINK_SHAPES) {
            this.world.linkShapeList().replaceShapes(LinkShape.parseShapes(e.lines, e.version));
        }
    }

    @Override
    public String getSource(String filename) throws IOException {
        String source2 = null;
        if (this.externalFileManager != null) {
            source2 = this.externalFileManager.getSource(filename);
        }
        if (source2 == null) {
            source2 = super.getSource(filename);
        }
        return source2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum KioskLevel {
        NONE,
        MODERATE;

    }
}

