/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Observer;
import org.nlogo.api.Dump;
import org.nlogo.api.Editable;
import org.nlogo.api.File;
import org.nlogo.api.PropertyDescription;
import org.nlogo.awt.Utils;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.MersenneTwisterFast;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.JobWidget;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class MonitorWidget
extends JobWidget
implements MouseListener,
Editable,
Events.JobRemovedEvent.Handler,
Events.PeriodicUpdateEvent.Handler,
Events.RuntimeErrorEvent.Handler {
    private boolean jobRunning = false;
    private boolean hasError = false;
    private String name = "";
    private int fontSize = 11;
    private Object value = null;
    private String valueString = "";
    private int decimalPlaces = 17;
    private boolean lastMousePressedWasPopupTrigger = false;

    public MonitorWidget(MersenneTwisterFast random) {
        super(random);
        this.setOpaque(true);
        this.addMouseListener(this);
        this.setBackground(InterfaceColors.MONITOR_BACKGROUND);
        this.setBorder(this.widgetBorder);
        Utils.adjustDefaultFont(this);
        this.fontSize = this.getFont().getSize();
    }

    public void name(String name) {
        this.name = name;
        this.chooseDisplayName();
    }

    public String name() {
        return this.name;
    }

    public void fontSize(int size) {
        this.fontSize = size;
        if (this.originalFont != null) {
            int zoomDiff = this.getFont().getSize() - this.originalFont.getSize();
            this.setFont(this.getFont().deriveFont(Float.valueOf(size + zoomDiff).floatValue()));
        } else {
            this.setFont(this.getFont().deriveFont(Float.valueOf(size).floatValue()));
        }
        if (this.originalFont != null) {
            this.originalFont = this.originalFont.deriveFont(Float.valueOf(size).floatValue());
        }
        this.resetZoomInfo();
        this.resetSizeInfo();
    }

    @Override
    public void setFont(Font f) {
        if (this.isZoomed() || this.getFont() == null) {
            super.setFont(f);
        } else {
            super.setFont(this.getFont().deriveFont(Float.valueOf(this.fontSize).floatValue()));
        }
    }

    @Override
    public String classDisplayName() {
        return "Monitor";
    }

    public Class<Observer> agentClass() {
        return Observer.class;
    }

    @Override
    public boolean ownsPrimaryJobs() {
        return false;
    }

    @Override
    public void procedure(Procedure procedure) {
        super.procedure(procedure);
        this.setForeground(procedure == null ? Color.RED : null);
        this.halt();
        if (procedure != null) {
            this.hasError = false;
            new Events.AddJobEvent(this, this.agents(), this.procedure()).raise(this);
            this.jobRunning = true;
        }
        this.repaint();
    }

    public void value(Object value) {
        this.value = value;
        String newString = Dump.logoObject(value);
        if (!newString.equals(this.valueString)) {
            this.valueString = newString;
            this.repaint();
        }
    }

    @Override
    public List<PropertyDescription> propertySet() {
        ArrayList<PropertyDescription> result = new ArrayList<PropertyDescription>();
        result.add(new PropertyDescription("wrapSource", "Reporter", "Reporter", 0, true));
        result.add(new PropertyDescription("name", "Display name", "String", 0, false));
        result.add(new PropertyDescription("decimalPlaces", "Decimal places", "full precision is 17", "Integer", -1, false));
        result.add(new PropertyDescription("fontSize", "Font Size", "Integer", -1, false));
        return result;
    }

    private void chooseDisplayName() {
        if (this.name() == null || this.name().equals("")) {
            this.displayName(this.getSourceName());
        } else {
            this.displayName(this.name());
        }
    }

    private String getSourceName() {
        return this.innerSource.trim().replaceAll("\\s+", " ");
    }

    @Override
    public void removeNotify() {
        if (EventQueue.isDispatchThread()) {
            this.halt();
        }
        super.removeNotify();
    }

    @Override
    public Dimension getMinimumSize() {
        int h = this.fontSize * 4 + 1;
        return new Dimension(50, h);
    }

    @Override
    public Dimension getMaximumSize() {
        int h = this.fontSize * 4 + 1;
        return new Dimension(10000, h);
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        Dimension size = this.getMinimumSize();
        int pad = 12;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        size.width = StrictMath.max(size.width, fontMetrics.stringWidth(this.displayName()) + pad);
        return size;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getMaxDescent() + fm.getMaxAscent();
        Dimension d = this.getSize();
        g.setColor(this.getForeground());
        String displayName = this.displayName();
        int boxHeight = (int)StrictMath.ceil((double)labelHeight * 1.4);
        g.drawString(displayName, 5, d.height - 6 - boxHeight - fm.getMaxDescent() - 1);
        g.setColor(Color.WHITE);
        g.fillRect(5, d.height - 6 - boxHeight, d.width - 5 - 6 - 1, boxHeight);
        g.setColor(Color.BLACK);
        if (!this.valueString.equals("")) {
            g.drawString(this.valueString, 10, d.height - 6 - 3 - fm.getMaxDescent());
        }
    }

    public int decimalPlaces() {
        return this.decimalPlaces;
    }

    @Override
    public void innerSource(String innerSource) {
        super.innerSource(innerSource);
        this.chooseDisplayName();
    }

    public void wrapSource(String innerSource) {
        if (innerSource.trim().equals("")) {
            this.source(null, "", null);
            this.halt();
        } else {
            this.source("to __monitor [] __observercode loop [ __updatemonitor __monitorprecision (", innerSource, "\n) " + this.decimalPlaces() + " ] end");
        }
        this.chooseDisplayName();
    }

    @Override
    public void handle(Events.RuntimeErrorEvent e) {
        if (this == e.jobOwner) {
            this.hasError = true;
            this.halt();
        }
    }

    @Override
    public void handle(Events.PeriodicUpdateEvent e) {
        if (!this.jobRunning && this.procedure() != null) {
            this.hasError = false;
            this.jobRunning = true;
            new Events.AddJobEvent(this, this.agents(), this.procedure()).raise(this);
        }
    }

    @Override
    public void handle(Events.JobRemovedEvent e) {
        if (e.owner == this) {
            this.jobRunning = false;
            this.value(this.hasError ? "N/A" : "");
        }
    }

    private void halt() {
        new Events.RemoveJobEvent(this).raise(this);
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        String displayName = strings[5];
        String source2 = File.restoreLines(strings[6]);
        if (displayName.equals("NIL")) {
            this.name("");
        } else {
            this.name(displayName);
        }
        if (strings.length > 7) {
            this.decimalPlaces = Integer.parseInt(strings[7]);
        }
        if (strings.length > 9) {
            this.fontSize(Integer.parseInt(strings[9]));
        }
        if (!source2.equals("NIL")) {
            this.wrapSource(helper.convert(source2, true));
        }
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        this.chooseDisplayName();
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isPopupTrigger() && this.error != null && !this.lastMousePressedWasPopupTrigger) {
            new Events.EditWidgetEvent(this, false).raise(this);
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastMousePressedWasPopupTrigger = e.isPopupTrigger();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

