/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import org.nlogo.agent.ConstantSliderConstraint;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.api.Approximate;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoException;
import org.nlogo.util.Exceptions;
import org.nlogo.window.SliderHorizontalPainter;
import org.nlogo.window.SliderPainter;
import org.nlogo.window.SliderVerticalPainter;
import org.nlogo.window.Widget;

public strictfp abstract class Slider
extends Widget {
    SliderConstraint constraint;
    SliderPainter painter;
    protected Double minimum = 0.0;
    protected Double maximum = 100.0;
    protected Double increment = 1.0;
    protected Double effectiveMaximum = 100.0;
    protected String name = "";
    protected String units = "";
    protected Double value = 50.0;

    public Slider() {
        this.setSliderConstraint(new ConstantSliderConstraint(this.minimum, this.maximum, this.increment));
        this.painter = new SliderHorizontalPainter(this);
        this.doLayout();
    }

    public void setSliderConstraint(SliderConstraint con) {
        this.constraint = con;
        try {
            Double newmin = con.minimum();
            Double newmax = con.maximum();
            Double newinc = con.increment();
            if (!(newmin.equals(this.minimum) && newmax.equals(this.maximum) && newinc.equals(this.increment))) {
                this.minimum = newmin;
                this.maximum = newmax;
                this.increment = newinc;
                this.effectiveMaximum = con.effectiveMaximum();
                this.value(this.coerceValue(this.value));
                this.revalidate();
                this.repaint();
            }
        }
        catch (SliderConstraint.RuntimeConstraintException ex) {
            this.setConstraintError(ex.constraint, ex);
            Exceptions.handle(ex);
        }
        catch (LogoException ex) {
            Exceptions.handle(ex);
        }
    }

    public void setConstraintError(String constraint, Exception ex) {
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
        this.repaint();
    }

    public void units(String units) {
        this.units = units;
        this.repaint();
    }

    public Double minimum() {
        return this.minimum;
    }

    public Double maximum() {
        return this.maximum;
    }

    public Double effectiveMaximum() {
        return this.effectiveMaximum;
    }

    public Double value() {
        return this.value;
    }

    public void value(Double value) {
        this.valueSetter(value);
    }

    public void value(Double value, boolean buttonRelease) {
        this.valueSetter(value);
    }

    protected void valueSetter(Double value) {
        if (!value.equals(this.value)) {
            this.value = value;
            this.revalidate();
            this.repaint();
        }
    }

    Double coerceValue(Double value) throws LogoException {
        value = (Double)this.constraint.coerceValue(value);
        Double effectiveMax = this.constraint.effectiveMaximum();
        Double min = this.constraint.minimum();
        Double inc = this.constraint.increment();
        int precision = this.constraint.getPrecision();
        if (value > effectiveMax) {
            value = effectiveMax;
        } else if (value <= min) {
            value = min;
        } else {
            value = Approximate.approximate(value, precision);
            double numDivisions = StrictMath.floor((value - min) / inc);
            double roundedDown = min + numDivisions * inc;
            double roundedUp = min + (numDivisions + 1.0) * inc;
            if (Approximate.approximate(roundedUp, precision) <= Approximate.approximate(effectiveMax, precision)) {
                double newValue = StrictMath.abs(value - roundedDown) < StrictMath.abs(roundedUp - value) ? roundedDown : roundedUp;
                value = newValue;
            } else {
                value = this.effectiveMaximum();
            }
        }
        return Approximate.approximate(value, precision);
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.painter.setToolTipText(text);
    }

    protected String valueString(Double num) {
        String numString = Dump.number(num);
        int precision = this.constraint.getPrecision();
        int place = numString.indexOf(46);
        if (precision > 0 && place == -1) {
            numString = numString + ".";
            place = numString.length() - 1;
        }
        if (place != -1 && numString.indexOf(69) == -1) {
            int padding = precision - (numString.length() - place - 1);
            for (int i = 0; i < padding; ++i) {
                numString = numString + '0';
            }
        }
        String result = numString;
        if (this.units.equals("")) {
            return result;
        }
        return result + " " + this.units;
    }

    public void vertical(boolean vert) {
        this.resetZoomInfo();
        this.resetSizeInfo();
        if (vert) {
            if (!(this.painter instanceof SliderVerticalPainter)) {
                this.painter.dettach();
                this.painter = new SliderVerticalPainter(this);
                this.validate();
            }
        } else if (!(this.painter instanceof SliderHorizontalPainter)) {
            this.painter.dettach();
            this.painter = new SliderHorizontalPainter(this);
            this.validate();
        }
    }

    public Dimension getMinimumSize() {
        return this.painter.getMinimumSize();
    }

    public Dimension getPreferredSize(Font font) {
        return this.painter.getPreferredSize(font);
    }

    public Dimension getMaximumSize() {
        return this.painter.getMaximumSize();
    }

    public void doLayout() {
        super.doLayout();
        this.painter.doLayout();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.painter.paintComponent(g);
    }
}

