/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.nlogo.agent.BooleanConstraint;
import org.nlogo.awt.Utils;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Widget;

public strictfp abstract class Switch
extends Widget
implements MouseWheelListener,
Events.AfterLoadEvent.Handler {
    protected BooleanConstraint constraint = new BooleanConstraint();
    protected final Channel channel = new Channel();
    protected final Dragger dragger = new Dragger();
    protected boolean nameChanged = false;
    protected String name = "";

    public Switch() {
        this.setBackground(InterfaceColors.SWITCH_BACKGROUND);
        this.setBorder(this.widgetBorder);
        this.setOpaque(true);
        Utils.adjustDefaultFont(this);
        this.add(this.dragger);
        this.add(this.channel);
        this.addMouseWheelListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                new Events.InputBoxLoseFocusEvent().raise(Switch.this);
            }
        });
    }

    public boolean isOn() {
        return (Boolean)this.constraint.defaultValue();
    }

    public void isOn(boolean on) {
        if (this.isOn() == on) {
            return;
        }
        this.constraint.defaultValue(on ? Boolean.TRUE : Boolean.FALSE);
        this.updateConstraints();
        this.doLayout();
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
        this.displayName(name);
        this.repaint();
    }

    public void updateConstraints() {
        if (this.name().length() > 0) {
            new Events.AddBooleanConstraintEvent(this.name, this.isOn() ? Boolean.TRUE : Boolean.FALSE).raise(this);
        }
    }

    public Dimension getPreferredSize(Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int height = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 6;
        int width = 18 + this.channel.getWidth() + fontMetrics.stringWidth(this.displayName()) + fontMetrics.stringWidth("Off");
        return new Dimension(StrictMath.max(90, width), StrictMath.max(33, height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(90, 33);
    }

    public Dimension getMaximumSize() {
        return new Dimension(10000, 33);
    }

    public void doLayout() {
        super.doLayout();
        float scaleFactor = (float)this.getHeight() / 33.0f;
        this.channel.setSize((int)(15.0f * scaleFactor), (int)(28.0f * scaleFactor));
        this.channel.setLocation(3, (this.getHeight() - this.channel.getHeight()) / 2);
        this.dragger.setSize((int)((double)this.channel.getWidth() * 0.9), (int)((double)this.channel.getHeight() * 0.35));
        this.dragger.setLocation(3 + (this.channel.getWidth() - this.dragger.getWidth()) / 2, this.channel.getY() + (this.isOn() ? (int)(0.1 * (double)this.channel.getHeight()) : this.channel.getHeight() - this.dragger.getHeight() - (int)(0.1 * (double)this.channel.getHeight())));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fontMetrics = g.getFontMetrics();
        int stringAscent = fontMetrics.getMaxAscent();
        Rectangle controlRect = this.channel.getBounds();
        g.setColor(this.getForeground());
        g.drawString("On", controlRect.width + 3, (this.getHeight() - 2 * stringAscent - 6) / 2 + stringAscent + 1);
        g.drawString("Off", controlRect.width + 3, (this.getHeight() - 2 * stringAscent - 6) / 2 + 2 * stringAscent + 1);
        int controlLabelWidth = StrictMath.max(fontMetrics.stringWidth("On"), fontMetrics.stringWidth("Off")) + controlRect.width + 6;
        g.setColor(this.getForeground());
        g.drawString(Utils.shortenStringToFit(this.displayName(), this.getWidth() - 9 - controlLabelWidth, fontMetrics), controlLabelWidth + 6, (this.getHeight() - fontMetrics.getHeight() - 6) / 2 + stringAscent + 1);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() >= 1) {
            this.isOn(false);
        } else {
            this.isOn(true);
        }
    }

    protected strictfp class Channel
    extends JComponent {
        Channel() {
            this.setOpaque(false);
            this.setBackground(Utils.mixColors(InterfaceColors.SWITCH_BACKGROUND, Color.BLACK, 0.5));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    new Events.InputBoxLoseFocusEvent().raise(Channel.this);
                    if (Utils.button1Mask(e)) {
                        Switch.this.isOn(!Switch.this.isOn());
                    }
                }
            });
        }

        public void paintComponent(Graphics g) {
            int x = (int)((double)this.getWidth() * 0.2);
            int y = (int)((double)this.getHeight() * 0.1);
            int width = (int)((double)this.getWidth() * 0.6);
            int height = (int)((double)this.getHeight() * 0.8);
            g.setColor(this.getBackground());
            g.fillRect(x, y, width, height);
            org.nlogo.swing.Utils.createWidgetBorder().paintBorder(this, g, x, y, width, height);
        }
    }

    protected strictfp class Dragger
    extends JPanel {
        Dragger() {
            this.setBackground(InterfaceColors.SWITCH_HANDLE);
            this.setBorder(org.nlogo.swing.Utils.createWidgetBorder());
            this.setOpaque(true);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    new Events.InputBoxLoseFocusEvent().raise(Switch.this);
                    Switch.this.isOn(!Switch.this.isOn());
                }
            });
        }
    }
}

