/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.Editable;
import org.nlogo.api.File;
import org.nlogo.api.PropertyDescription;
import org.nlogo.awt.Utils;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class TextBoxWidget
extends Widget
implements Editable {
    private int width = 150;
    private String text = "";
    private Color color = Color.black;
    private int fontSize;

    public String text() {
        return this.text;
    }

    public void text(String text) {
        this.text = text;
        this.repaint();
    }

    public void transparency(boolean trans) {
        this.setBackground(trans ? InterfaceColors.TRANSPARENT : InterfaceColors.TEXT_BOX_BACKGROUND);
        this.setOpaque(!trans);
    }

    public TextBoxWidget() {
        this.setBackground(InterfaceColors.TRANSPARENT);
        this.setOpaque(false);
        Utils.adjustDefaultFont(this);
        this.fontSize = this.getFont().getSize();
    }

    @Override
    public List<PropertyDescription> propertySet() {
        ArrayList<PropertyDescription> result = new ArrayList<PropertyDescription>();
        result.add(new PropertyDescription("text", "Text", "BigString", 0, true, false));
        result.add(new PropertyDescription("fontSize", "Font Size", "Integer", 0, false));
        result.add(new PropertyDescription("transparency", "Transparent background", "Boolean", 0, false));
        result.add(new PropertyDescription("color", "Text Color", "Color", 0, false));
        return result;
    }

    public void color(Color color) {
        this.color = color;
    }

    public void fontSize(int size) {
        this.fontSize = size;
        if (this.isZoomed() && this.originalFont != null) {
            int zoomDiff = 0;
            zoomDiff = this.getFont().getSize() - this.originalFont.getSize();
            this.setFont(this.getFont().deriveFont(Float.valueOf(size + zoomDiff).floatValue()));
        } else {
            this.setFont(this.getFont().deriveFont(Float.valueOf(size).floatValue()));
        }
        if (this.originalFont != null) {
            this.originalFont = this.originalFont.deriveFont(Float.valueOf(size).floatValue());
        }
        this.resetZoomInfo();
        this.resetSizeInfo();
    }

    @Override
    public String classDisplayName() {
        return "Note";
    }

    @Override
    public String displayName() {
        return this.text();
    }

    @Override
    public void setBounds(Rectangle r) {
        if (r.width > 0) {
            this.width = r.width;
        }
        super.setBounds(r);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width > 0) {
            this.width = width;
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(15, 18);
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        FontMetrics metrics = this.getFontMetrics(font);
        int height = Utils.breakLines(this.text(), metrics, this.width).size() * (metrics.getMaxDescent() + metrics.getMaxAscent());
        return new Dimension(StrictMath.max(15, this.width), StrictMath.max(18, height));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(this.getFont());
        FontMetrics metrics = g.getFontMetrics();
        int stringHeight = metrics.getMaxDescent() + metrics.getMaxAscent();
        int stringAscent = metrics.getMaxAscent();
        List<String> lines = Utils.breakLines(this.text(), metrics, this.width);
        g.setColor(this.color);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            g.drawString(line, 0, i * stringHeight + stringAscent);
        }
    }

    @Override
    public Object load(String[] strings, Widget.LoadHelper helper) {
        if (strings[5].equals("NIL")) {
            this.text("");
        } else {
            this.text(File.restoreLines(strings[5]));
        }
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        if (strings.length >= 7) {
            this.fontSize(Integer.parseInt(strings[6]));
        }
        if (strings.length >= 8) {
            this.color(org.nlogo.api.Color.getColor(Double.parseDouble(strings[7])));
        }
        if (strings.length >= 9) {
            this.transparency(Integer.parseInt(strings[8]) != 0);
        } else {
            this.transparency(false);
        }
        this.setSize(x2 - x1, y2 - y1);
        return this;
    }
}

