/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import org.nlogo.agent.World;
import org.nlogo.api.CommandRunnable;
import org.nlogo.api.LogoException;
import org.nlogo.api.ReporterRunnable;
import org.nlogo.awt.Utils;
import org.nlogo.nvm.HaltException;
import org.nlogo.util.Exceptions;
import org.nlogo.window.GUIWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
strictfp final class ThreadUtils {
    private static final CommandRunnable DO_NOTHING = new CommandRunnable(){

        public void run() {
        }
    };

    private ThreadUtils() {
        throw new IllegalStateException();
    }

    static void waitForQueuedEvents(GUIWorkspace workspace) throws LogoException {
        ThreadUtils.waitFor(workspace, DO_NOTHING);
    }

    static void waitFor(GUIWorkspace workspace, final Runnable runnable) {
        try {
            ThreadUtils.waitForResult(workspace, new ReporterRunnable<Object>(){

                @Override
                public Object run() {
                    runnable.run();
                    return Boolean.TRUE;
                }
            });
        }
        catch (HaltException ex) {
            Exceptions.ignore(ex);
        }
        catch (LogoException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static void waitFor(GUIWorkspace workspace, final CommandRunnable runnable) throws LogoException {
        ThreadUtils.waitForResult(workspace, new ReporterRunnable<Object>(){

            @Override
            public Object run() throws LogoException {
                runnable.run();
                return Boolean.TRUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T waitForResult(final GUIWorkspace workspace, final ReporterRunnable<T> runnable) throws LogoException {
        if (workspace.isHeadless()) {
            return runnable.run();
        }
        final Result result = new Result();
        try {
            Utils.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        result.value = runnable.run();
                    }
                    catch (LogoException ex) {
                        result.ex = ex;
                    }
                    catch (RuntimeException ex) {
                        result.ex = ex;
                    }
                    finally {
                        result.done = true;
                        World ex = workspace.world;
                        synchronized (ex) {
                            workspace.world.notifyAll();
                        }
                    }
                }
            });
            while (!result.done) {
                World world = workspace.world;
                synchronized (world) {
                    workspace.world.wait(50L);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
            if (result.ex instanceof LogoException) {
                throw (LogoException)result.ex;
            }
            if (result.ex instanceof RuntimeException) {
                throw (RuntimeException)result.ex;
            }
            return result.value;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new HaltException(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private strictfp static class Result<T> {
        volatile boolean done = false;
        T value = null;
        Exception ex = null;

        private Result() {
        }
    }
}

