/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import org.nlogo.workspace.AbstractWorkspace;

strictfp class UpdateManager {
    private final AbstractWorkspace workspace;
    private long lastUpdateNanos = 0L;
    private double lastUpdateTicks = -1.0;
    private int pseudoTicks = 0;
    private long nanoGap = 0L;
    private double tickGap = 1.0;
    private double speed = 0.0;

    UpdateManager(AbstractWorkspace workspace) {
        this.workspace = workspace;
    }

    void reset() {
        this.lastUpdateTicks = -1.0;
        this.pseudoTicks = 0;
        this.lastUpdateNanos = 0L;
    }

    void pseudoTick() {
        ++this.pseudoTicks;
    }

    boolean enoughWhateverPassed() {
        double ticks = this.workspace.world.tickCounter.ticks();
        if (ticks < this.lastUpdateTicks) {
            this.lastUpdateTicks = -1.0;
        }
        double ticksSinceUpdate = ticks - this.lastUpdateTicks + (double)this.pseudoTicks;
        switch (this.workspace.updateMode()) {
            case CONTINUOUS: {
                return this.enoughTimePassed() || ticksSinceUpdate >= this.tickGap;
            }
            case TICK_BASED: {
                return ticksSinceUpdate >= this.tickGap || this.speed > 0.0 && ticksSinceUpdate >= 1.0 && this.enoughTimePassed();
            }
        }
        throw new IllegalStateException();
    }

    private boolean enoughTimePassed() {
        return System.nanoTime() - this.lastUpdateNanos >= this.nanoGap;
    }

    void donePainting() {
        this.lastUpdateNanos = System.nanoTime();
        this.lastUpdateTicks = this.workspace.world.tickCounter.ticks();
        this.pseudoTicks = 0;
    }

    double speed() {
        return this.speed;
    }

    void speed(double speed) {
        this.speed = speed;
        this.updateTickGap();
    }

    void updateTickGap() {
        switch (this.workspace.updateMode()) {
            case TICK_BASED: {
                this.nanoGap = this.speed < 0.0 ? 0L : 1000000L * (long)(this.speed + StrictMath.pow(StrictMath.pow(3000.0, 0.02), this.speed));
                this.tickGap = this.speed < 0.0 ? StrictMath.pow(StrictMath.pow(0.01, 0.02), -this.speed) : (double)((int)(this.speed + StrictMath.pow(StrictMath.pow(5000.0, 0.04), this.speed)));
                break;
            }
            case CONTINUOUS: {
                this.nanoGap = this.speed < -12.0 ? 1000000L : 1000000L * (long)(this.speed + 12.0 + StrictMath.pow(StrictMath.pow(3000.0, 0.016129032258064516), this.speed + 12.0));
                this.tickGap = this.speed <= -25.0 ? 1.0 : (double)((int)(this.speed + 25.0 + StrictMath.pow(StrictMath.pow(50000.0, 0.04), this.speed + 25.0)));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private long updatePauseNanos() {
        switch (this.workspace.updateMode()) {
            case TICK_BASED: {
                return this.speed >= 0.0 ? 0L : 1000000L * (long)StrictMath.pow(StrictMath.pow(9000.0, 0.02), -this.speed);
            }
            case CONTINUOUS: {
                return this.speed < -25.0 ? 1000000L * (long)StrictMath.pow(StrictMath.pow(1500.0, 0.04), -25.0 - this.speed) : 0L;
            }
        }
        throw new IllegalStateException();
    }

    synchronized void nudgeSleeper() {
        this.notifyAll();
    }

    synchronized void pauseAfterDisplayUpdate() {
        long pause = this.updatePauseNanos();
        if (pause <= 0L) {
            return;
        }
        long timeToBed = System.nanoTime();
        try {
            while (pause > 0L) {
                this.wait(pause / 1000000L, (int)(pause % 1000000L));
                pause = this.updatePauseNanos() - System.nanoTime() + timeToBed;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

