/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import org.nlogo.awt.RowLayout;
import org.nlogo.awt.Utils;
import org.nlogo.swing.OptionDialog;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.SpeedSliderPanel;
import org.nlogo.window.ViewWidget;

public strictfp class ViewControlStrip
extends JPanel {
    private final GUIWorkspace workspace;
    private final ViewWidget viewWidget;
    private final SizeControl sizeControlXY;
    private final SizeControl sizeControlX;
    private final SizeControl sizeControlY;
    private static final Point TOOL_TIP_OFFSET = new Point(0, -18);

    ViewControlStrip(GUIWorkspace workspace, ViewWidget viewWidget) {
        this.workspace = workspace;
        this.viewWidget = viewWidget;
        this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
        BorderLayout layout = new BorderLayout();
        layout.setVgap(0);
        this.setLayout(layout);
        if (workspace.kioskLevel == GUIWorkspace.KioskLevel.NONE) {
            JPanel sizeControlPanel = new JPanel();
            sizeControlPanel.setLayout(new RowLayout(1, 1.0f, 0.5f));
            this.sizeControlXY = new SizeControl("/images/arrowsdiag.gif", 1, 1);
            this.sizeControlXY.setToolTipText("Change width and height of world");
            sizeControlPanel.add(this.sizeControlXY);
            this.sizeControlX = new SizeControl("/images/arrowsx.gif", 1, 0);
            this.sizeControlX.setToolTipText("Change width of world");
            sizeControlPanel.add(this.sizeControlX);
            this.sizeControlY = new SizeControl("/images/arrowsy.gif", 0, 1);
            this.sizeControlY.setToolTipText("Change height of world");
            sizeControlPanel.add(this.sizeControlY);
            this.add((Component)sizeControlPanel, "West");
            sizeControlPanel.setOpaque(false);
            this.add((Component)viewWidget.tickCounter, "Center");
        } else {
            this.sizeControlXY = null;
            this.sizeControlX = null;
            this.sizeControlY = null;
            this.add((Component)viewWidget.tickCounter, "West");
            SpeedSliderPanel speedSlider = new SpeedSliderPanel(workspace, false);
            speedSlider.setOpaque(false);
            this.add((Component)speedSlider, "Center");
        }
        if (workspace.kioskLevel == GUIWorkspace.KioskLevel.NONE) {
            ThreedButton threedButton = new ThreedButton();
            this.add((Component)threedButton, "East");
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(super.getMinimumSize().width, 20);
    }

    public Dimension getPreferredSize() {
        if (this.viewWidget.isZoomed()) {
            return super.getPreferredSize();
        }
        return new Dimension(super.getPreferredSize().width, 20);
    }

    public void doLayout() {
        if (this.workspace.kioskLevel == GUIWorkspace.KioskLevel.NONE) {
            this.sizeControlXY.setVisible(true);
            this.sizeControlX.setVisible(true);
            this.sizeControlY.setVisible(true);
        }
        super.doLayout();
    }

    void reset() {
        this.enableSizeControls(this.workspace.world.maxPxcor() == -this.workspace.world.minPxcor() || this.workspace.world.minPxcor() == 0 || this.workspace.world.maxPxcor() == 0, this.workspace.world.maxPycor() == -this.workspace.world.minPycor() || this.workspace.world.minPycor() == 0 || this.workspace.world.maxPycor() == 0);
        this.doLayout();
    }

    void enableSizeControls(boolean x, boolean y) {
        if (this.workspace.kioskLevel == GUIWorkspace.KioskLevel.NONE) {
            this.sizeControlX.setEnabled(x);
            this.sizeControlY.setEnabled(y);
            this.sizeControlXY.setEnabled(x && y);
        }
    }

    private boolean newSizeOK(int sizeX, int sizeY) {
        return sizeX >= 1 && sizeY >= 1 && this.workspace.world.patchSize() * (double)sizeX >= (double)this.getMinimumSize().width;
    }

    private boolean checkWithUser() {
        return !this.workspace.jobManager.anyPrimaryJobs() || OptionDialog.show(this, "Warning", "Changing the size will halt and clear the world.", new String[]{"Change Size", "Cancel"}) == 0;
    }

    private strictfp class SizeControl
    extends JButton
    implements ActionListener {
        private final int sexChange;
        private final int seyChange;
        private Point mousePressLoc;

        SizeControl(String string, int n, int n2) {
            this.sexChange = n;
            this.seyChange = n2;
            this.setOpaque(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.setIcon(new ImageIcon(SizeControl.class.getResource(string)));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    SizeControl.this.mousePressLoc = e.getPoint();
                }
            });
            this.addActionListener(this);
        }

        public Point getToolTipLocation(MouseEvent e) {
            return TOOL_TIP_OFFSET;
        }

        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }

        private boolean increase() {
            if (this.sexChange == 1 && this.seyChange == 0) {
                return this.mousePressLoc.x >= this.getWidth() / 2;
            }
            if (this.sexChange == 0 && this.seyChange == 1) {
                return this.mousePressLoc.y >= this.getHeight() / 2;
            }
            return this.mousePressLoc.x + this.mousePressLoc.y >= (this.getHeight() + this.getWidth()) / 2;
        }

        public void actionPerformed(ActionEvent e) {
            if (!ViewControlStrip.this.checkWithUser()) {
                return;
            }
            int maxPxcor = ((ViewControlStrip)ViewControlStrip.this).workspace.world.maxPxcor();
            int minPxcor = ((ViewControlStrip)ViewControlStrip.this).workspace.world.minPxcor();
            int maxPycor = ((ViewControlStrip)ViewControlStrip.this).workspace.world.maxPycor();
            int minPycor = ((ViewControlStrip)ViewControlStrip.this).workspace.world.minPycor();
            int deltax = this.sexChange * (this.increase() ? 1 : -1);
            int deltay = this.seyChange * (this.increase() ? 1 : -1);
            int minx = minPxcor;
            int maxx = maxPxcor;
            int miny = minPycor;
            int maxy = maxPycor;
            if (maxPxcor == -minPxcor) {
                minx = minPxcor - deltax;
                maxx = maxPxcor + deltax;
            } else if (maxPxcor == 0) {
                minx = minPxcor - deltax;
            } else if (minPxcor == 0) {
                maxx = maxPxcor + deltax;
            }
            if (maxPycor == -minPycor) {
                miny = minPycor - deltay;
                maxy = maxPycor + deltay;
            } else if (maxPycor == 0) {
                miny = minPycor - deltay;
            } else if (minPycor == 0) {
                maxy = maxPycor + deltay;
            }
            if (ViewControlStrip.this.newSizeOK(maxx - minx, maxy - miny) && (minx != minPxcor || maxx != maxPxcor || miny != minPycor || maxy != maxPycor)) {
                ViewWidget viewWidget = (ViewWidget)((ViewControlStrip)ViewControlStrip.this).workspace.view.getParent();
                viewWidget.settings().setDimensions(minx, maxx, miny, maxy);
                viewWidget.settings().resizeWithProgress(false);
            }
        }
    }

    private strictfp class ThreedButton
    extends JButton {
        public ThreedButton() {
            super(" 3D ");
            this.setFont(new Font(Utils.platformFont(), 0, 10));
            this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
            this.setBorder(org.nlogo.swing.Utils.createWidgetBorder());
            this.setFocusable(false);
            this.setToolTipText("Switch to 3D view");
            this.addActionListener(((ViewControlStrip)ViewControlStrip.this).workspace.switchTo3DViewAction);
        }

        public Point getToolTipLocation(MouseEvent e) {
            return TOOL_TIP_OFFSET;
        }

        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }
    }
}

