/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.LinkedList;
import org.nlogo.api.ViewInterface;
import org.nlogo.awt.Utils;
import org.nlogo.window.LocalViewInterface;

public strictfp class ViewManager {
    private final LinkedList<ViewInterface> views = new LinkedList();
    private final Runnable updateRunnable = new Runnable(){

        public void run() {
            ViewManager.this.incrementalUpdateFromEventThread();
        }
    };

    public LocalViewInterface getPrimary() {
        return (LocalViewInterface)this.views.get(0);
    }

    public void setPrimary(LocalViewInterface view) {
        this.views.remove(view);
        this.views.addFirst(view);
    }

    public void add(ViewInterface v) {
        this.views.addLast(v);
    }

    public void remove(ViewInterface v) {
        this.views.remove(v);
    }

    void paintImmediately(boolean force) {
        for (ViewInterface view : this.views) {
            view.paintImmediately(force);
        }
    }

    void framesSkipped() {
        for (ViewInterface v : this.views) {
            v.framesSkipped();
        }
    }

    void incrementalUpdateFromEventThread() {
        for (ViewInterface v : this.views) {
            if (v.isDead() || !v.viewIsVisible()) continue;
            v.incrementalUpdateFromEventThread();
        }
    }

    void incrementalUpdateFromJobThread() {
        try {
            Utils.invokeAndWait(this.updateRunnable);
        }
        catch (InterruptedException ex) {
            this.getPrimary().repaint();
        }
    }

    void applyNewFontSize(int newFontSize) {
        for (ViewInterface v : this.views) {
            v.applyNewFontSize(newFontSize, 0);
        }
    }

    public boolean mouseDown() {
        for (ViewInterface view : this.views) {
            if (!view.mouseDown()) continue;
            return true;
        }
        return false;
    }

    public boolean mouseInside() {
        for (ViewInterface view : this.views) {
            if (!view.mouseInside()) continue;
            return true;
        }
        return false;
    }

    public double mouseXCor() {
        for (ViewInterface view : this.views) {
            if (!view.mouseInside()) continue;
            return view.mouseXCor();
        }
        return this.getPrimary().mouseXCor();
    }

    public double mouseYCor() {
        for (ViewInterface view : this.views) {
            if (!view.mouseInside()) continue;
            return view.mouseYCor();
        }
        return this.getPrimary().mouseYCor();
    }

    public void resetMouseCors() {
        for (ViewInterface view : this.views) {
            view.resetMouseCors();
        }
    }
}

