/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.nlogo.api.Approximate;
import org.nlogo.api.Dump;
import org.nlogo.api.Version;
import org.nlogo.awt.Utils;
import org.nlogo.window.DisplaySwitch;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.View;
import org.nlogo.window.ViewControlStrip;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import org.nlogo.window.WorldViewSettings;
import org.nlogo.window.WorldViewSettings2D;
import org.nlogo.window.WorldViewSettings3D;

public strictfp class ViewWidget
extends Widget
implements Events.LoadBeginEvent.Handler,
Events.LoadEndEvent.Handler,
Events.PeriodicUpdateEvent.Handler,
ViewWidgetInterface {
    private final GUIWorkspace workspace;
    public final View view;
    public final ViewControlStrip controlStrip;
    public final JLabel tickCounter = new TickCounterLabel();
    public final DisplaySwitch displaySwitch;
    private final WorldViewSettings settings;
    private String tickCounterLabel;

    public String classDisplayName() {
        return "World & View";
    }

    public final int getExtraHeight() {
        return this.getInsets().top + this.getInsets().bottom + 1;
    }

    public int getAdditionalHeight() {
        return this.getExtraHeight() + this.controlStrip.getHeight();
    }

    ViewWidget(GUIWorkspace workspace) {
        this.workspace = workspace;
        this.displaySwitch = new DisplaySwitch(workspace);
        Utils.adjustDefaultFont(this.tickCounter);
        this.view = new View(workspace);
        this.controlStrip = new ViewControlStrip(workspace, this);
        this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
        this.setBorder(BorderFactory.createCompoundBorder(this.widgetBorder, BorderFactory.createMatteBorder(1, 3, 4, 2, InterfaceColors.GRAPHICS_BACKGROUND)));
        this.setLayout(null);
        this.add(this.view);
        this.add(this.controlStrip);
        this.settings = Version.is3D() ? new WorldViewSettings3D(workspace, this) : new WorldViewSettings2D(workspace, this);
    }

    public WorldViewSettings settings() {
        return this.settings;
    }

    public void doLayout() {
        int availableWidth = this.getWidth() - this.getInsets().left - this.getInsets().right;
        double patchSize = this.computePatchSize(availableWidth, this.workspace.world.worldWidth());
        int graphicsHeight = (int)StrictMath.round(patchSize * (double)this.workspace.world.worldHeight());
        int stripHeight = this.getHeight() - graphicsHeight - this.getInsets().top - this.getInsets().bottom;
        this.view.visualPatchSize(patchSize);
        this.view.setBounds(this.getInsets().left, this.getInsets().top + 1 + stripHeight, availableWidth, graphicsHeight);
        this.controlStrip.setBounds(this.getInsets().left, this.getInsets().top, availableWidth, stripHeight);
    }

    public double computePatchSize(int width, int numPatches) {
        double exactPatchSize = (double)width / (double)numPatches;
        for (int precision = 0; precision < 15; ++precision) {
            double roundedPatchSize = Approximate.approximate(exactPatchSize, precision);
            if ((int)((double)numPatches * roundedPatchSize) != width) continue;
            return roundedPatchSize;
        }
        return exactPatchSize;
    }

    public Dimension getPreferredSize(Font font) {
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        Dimension gSize = this.view.getMinimumSize();
        Dimension stripSize = this.controlStrip.getMinimumSize();
        if (gSize.width > stripSize.width) {
            return new Dimension(gSize.width + this.getInsets().left + this.getInsets().right, gSize.height + this.getExtraHeight() + stripSize.height);
        }
        int ssx = this.workspace.world.worldWidth();
        int ssy = this.workspace.world.worldHeight();
        double minPatchSize = this.computePatchSize(stripSize.width, ssx);
        return new Dimension(stripSize.width + this.getInsets().left + this.getInsets().right, stripSize.height + this.getExtraHeight() + (int)(minPatchSize * (double)ssy));
    }

    public int insetWidth() {
        return this.getInsets().left + this.getInsets().right;
    }

    public int calculateWidth(int worldWidth, double patchSize) {
        return (int)((double)worldWidth * patchSize) + this.getInsets().right + this.getInsets().left;
    }

    public int calculateHeight(int worldHeight, double patchSize) {
        Dimension stripSize = this.controlStrip.getMinimumSize();
        return stripSize.height + this.getExtraHeight() + (int)(patchSize * (double)worldHeight);
    }

    public int getMinimumWidth() {
        return this.controlStrip.getMinimumSize().width + this.insetWidth();
    }

    void resetSize() {
        this.view.setSize(this.workspace.world.worldWidth(), this.workspace.world.worldHeight(), this.workspace.world.patchSize());
        Dimension dim = this.view.getPreferredSize();
        this.setSize(dim.width + this.getInsets().left + this.getInsets().right, dim.height + this.getExtraHeight() + this.controlStrip.getPreferredSize().height);
        this.doLayout();
        this.resetZoomInfo();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        new Events.ResizeViewEvent(this.workspace.world.worldWidth(), this.workspace.world.worldHeight()).raise(this);
    }

    public void setBounds(int x, int y, int width, int height) {
        Rectangle bounds = this.getBounds();
        if (width != bounds.width || height != bounds.height || x != bounds.x || y != bounds.y) {
            super.setBounds(x, y, width, height);
            this.resetSizeInfo();
        }
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    void applyNewFontSize(int newFontSize) {
        Font font = this.view.getFont();
        int zoomDiff = font.getSize() - this.view.fontSize();
        this.view.applyNewFontSize(newFontSize, zoomDiff);
    }

    public Widget asWidget() {
        return this;
    }

    public void handle(Events.LoadBeginEvent e) {
        this.tickCounter.setText("");
        this.tickCounterLabel = "ticks";
        this.tickCounter.setVisible(true);
    }

    public void handle(Events.LoadEndEvent e) {
        this.controlStrip.reset();
    }

    public void handle(Events.PeriodicUpdateEvent e) {
        this.tickCounter.setText("     " + this.tickCounterLabel + ": " + Dump.number(StrictMath.floor(this.workspace.world.tickCounter.ticks())));
    }

    public void showTickCounter(boolean visible) {
        this.tickCounter.setVisible(visible);
    }

    public void tickCounterLabel(String label) {
        this.tickCounterLabel = label;
        this.handle((Events.PeriodicUpdateEvent)null);
    }

    public boolean hasContextMenu() {
        return true;
    }

    public Point populateContextMenu(JPopupMenu menu, Point p, Component source2) {
        return this.view.populateContextMenu(menu, p, source2);
    }

    void displaySwitchOn(boolean on) {
        this.displaySwitch.actionPerformed(null);
    }

    public Object load(String[] strings, Widget.LoadHelper helper) {
        return this.settings.load(strings, helper.version());
    }

    private strictfp class TickCounterLabel
    extends JLabel {
        private TickCounterLabel() {
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            d.width = StrictMath.max(d.width, fontMetrics.stringWidth(ViewWidget.this.tickCounterLabel + ": 00000000"));
            return d;
        }
    }
}

