/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.nlogo.awt.Utils;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.WidgetContainer;

public strictfp abstract class Widget
extends JPanel {
    protected final Border widgetBorder = org.nlogo.swing.Utils.createWidgetBorder();
    protected final Border widgetPressedBorder = org.nlogo.swing.Utils.createWidgetPressedBorder();
    protected Exception error = null;
    protected String errorProperty = null;
    private boolean deleteable = true;
    private String displayName = "";
    private final MouseListener popupListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Widget.this.doPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Widget.this.doPopup(e);
            }
        }
    };
    protected Font originalFont = null;

    public String classDisplayName() {
        return this.getClass().getName();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
    }

    public void addNotify() {
        super.addNotify();
        if (this.originalFont == null) {
            this.originalFont = this.getFont();
        }
        Event.rehash();
        new Events.WidgetAddedEvent(this).raise(this);
    }

    public void removeNotify() {
        if (EventQueue.isDispatchThread()) {
            Event.rehash();
            new Events.WidgetRemovedEvent(this).raise(this);
        }
        super.removeNotify();
    }

    public boolean editFinished() {
        new Events.WidgetEditedEvent(this).raise(this);
        return true;
    }

    public Exception error() {
        return this.error;
    }

    public String errorProperty() {
        return this.errorProperty;
    }

    public int sourceOffset() {
        return 0;
    }

    public String displayName() {
        return this.displayName;
    }

    public void displayName(String displayName) {
        this.displayName = displayName;
        this.invalidate();
        this.repaint();
    }

    public boolean hasContextMenu() {
        return false;
    }

    public Point populateContextMenu(JPopupMenu menu, Point p, Component source2) {
        return p;
    }

    private void doPopup(MouseEvent e) {
        if (this.hasContextMenu()) {
            JPopupMenu menu = new JPopupMenu();
            this.populateContextMenu(menu, e.getPoint(), (Component)e.getSource());
            if (menu.getSubElements().length > 0) {
                menu.show((Component)e.getSource(), e.getX(), e.getY());
            }
            e.consume();
        }
    }

    void addPopupListeners() {
        this.addPopupListeners(this, this.popupListener);
    }

    private void addPopupListeners(Component component, MouseListener popupListener) {
        component.addMouseListener(popupListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.addPopupListeners(container.getComponent(i), popupListener);
            }
        }
    }

    public boolean isButton() {
        return false;
    }

    public boolean isTurtleForeverButton() {
        return false;
    }

    public boolean isLinkForeverButton() {
        return false;
    }

    public WidgetContainer findWidgetContainer() {
        return (WidgetContainer)((Object)Utils.findAncestorOfClass(this, WidgetContainer.class));
    }

    protected void resetZoomInfo() {
        if (this.findWidgetContainer() != null) {
            this.findWidgetContainer().resetZoomInfo(this);
        }
    }

    protected void resetSizeInfo() {
        if (this.findWidgetContainer() != null) {
            this.findWidgetContainer().resetSizeInfo(this);
        }
    }

    public boolean isZoomed() {
        if (this.findWidgetContainer() != null) {
            return this.findWidgetContainer().isZoomed();
        }
        return false;
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getFont());
    }

    public Dimension getPreferredSize(Font font) {
        return super.getPreferredSize();
    }

    public abstract Object load(String[] var1, LoadHelper var2);

    public String toString() {
        String sup = super.toString();
        if (this.displayName() != null && !this.displayName().equals("")) {
            return sup + "(" + this.displayName() + ")";
        }
        return sup;
    }

    public void updateConstraints() {
    }

    public static interface LoadHelper {
        public String version();

        public String convert(String var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum MouseMode {
        IDLE,
        DRAG,
        NE,
        NW,
        SE,
        SW,
        S,
        W,
        E,
        N;

    }
}

