/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import org.nlogo.agent.World;
import org.nlogo.api.LogoException;
import org.nlogo.api.PropertyDescription;
import org.nlogo.awt.Utils;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WorldViewSettings;

public strictfp class WorldViewSettings2D
extends WorldViewSettings {
    protected final World world;

    WorldViewSettings2D(GUIWorkspace workspace, ViewWidget gw) {
        super(workspace, gw);
        this.world = workspace.world;
    }

    public void addDimensionProperties() {
        this.dimensionProperties.add(new PropertyDescription("minPxcor", "min-pxcor", "minimum x coordinate for patches", "Negative Integer", 0, false, true));
        this.dimensionProperties.add(new PropertyDescription("maxPxcor", "max-pxcor", "maximum x coordinate for patches", "Positive Integer", 0, false, true));
        this.dimensionProperties.add(new PropertyDescription("minPycor", "min-pycor", "minimum y coordinate for patches", "Negative Integer", 0, false, true));
        this.dimensionProperties.add(new PropertyDescription("maxPycor", "max-pycor", "maximum y coordinate for patches", "Positive Integer", 0, false, true));
    }

    public void addWrappingProperties() {
        this.wrappingProperties.add(new PropertyDescription("wrappingX", "World wraps horizontally", "Boolean", 0, false, true));
        this.wrappingProperties.add(new PropertyDescription("wrappingY", "World wraps vertically", "Boolean", 0, false, true));
    }

    public boolean editFinished() {
        this.gWidget.editFinished();
        if (this.wrappingChanged) {
            this.workspace.changeTopology(this.newWrapX, this.newWrapY);
            this.wrappingChanged = false;
        }
        if (this.edgesChanged || this.patchSizeChanged) {
            this.resizeWithProgress(true);
            this.edgesChanged = false;
            this.patchSizeChanged = false;
        }
        if (this.fontSizeChanged) {
            this.gWidget.applyNewFontSize(this.newFontSize);
            this.fontSizeChanged = false;
        }
        this.gWidget.view.dirty();
        this.gWidget.view.repaint();
        this.workspace.glView.editFinished();
        return true;
    }

    public void resizeWithProgress(boolean showProgress) {
        boolean oldGraphicsOn = this.world.displayOn();
        if (oldGraphicsOn) {
            this.world.displayOn(false);
        }
        Runnable runnable = new Runnable(){
            final int KICK = 0;
            final int IGNORE = 1;

            public void run() {
                if (WorldViewSettings2D.this.edgesChanged) {
                    new Events.RemoveAllJobsEvent().raise(WorldViewSettings2D.this.gWidget);
                    if (this.hubnetDecision() == 0) {
                        try {
                            WorldViewSettings2D.this.workspace.hubnetManager().reset();
                        }
                        catch (LogoException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    WorldViewSettings2D.this.world.clearTurtles();
                    WorldViewSettings2D.this.world.clearLinks();
                    WorldViewSettings2D.this.world.createPatches(WorldViewSettings2D.this.newMinX, WorldViewSettings2D.this.newMaxX, WorldViewSettings2D.this.newMinY, WorldViewSettings2D.this.newMaxY);
                    WorldViewSettings2D.this.workspace.patchesCreatedNotify();
                    WorldViewSettings2D.this.gWidget.resetSize();
                }
                if (WorldViewSettings2D.this.patchSizeChanged) {
                    WorldViewSettings2D.this.world.patchSize(WorldViewSettings2D.this.newPatchSize);
                    WorldViewSettings2D.this.gWidget.resetSize();
                }
                if (WorldViewSettings2D.this.edgesChanged) {
                    WorldViewSettings2D.this.gWidget.view.renderer.trailDrawer().clearDrawing();
                } else {
                    WorldViewSettings2D.this.gWidget.view.renderer.trailDrawer().rescaleDrawing();
                }
            }

            private int hubnetDecision() {
                if (WorldViewSettings2D.this.workspace.computerHubNetRunning()) {
                    String message = "Resizing the world kills all turtles. This may cause HubNet clients to be unresponsive. Consider kicking out all clients before proceeding.";
                    return OptionDialog.show(WorldViewSettings2D.this.workspace.getFrame(), "Kick clients?", message, new String[]{"Kick clients", "Don't kick"});
                }
                return 1;
            }
        };
        if (showProgress) {
            new ModalProgressTask(Utils.getFrame(this.gWidget), runnable, "Resizing...");
        } else {
            runnable.run();
        }
        this.gWidget.displaySwitchOn(true);
        if (oldGraphicsOn) {
            this.world.displayOn(true);
            this.gWidget.view.dirty();
            this.gWidget.view.repaint();
        }
    }
}

