/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import org.nlogo.agent.World3D;
import org.nlogo.api.PropertyDescription;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldDimensions3D;
import org.nlogo.awt.Utils;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.OriginConfiguration;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WorldViewSettings;

public strictfp class WorldViewSettings3D
extends WorldViewSettings {
    protected final World3D world;
    protected int newMinZ;
    protected int newMaxZ;

    WorldViewSettings3D(GUIWorkspace workspace, ViewWidget gw) {
        super(workspace, gw);
        this.world = (World3D)workspace.world;
    }

    public void addDimensionProperties() {
        this.dimensionProperties.add(new PropertyDescription("minPxcor", "min-pxcor", "minimum x coordinate for patches", "Negative Integer", 0, false, true));
        this.dimensionProperties.add(new PropertyDescription("maxPxcor", "max-pxcor", "maximum x coordinate for patches", "Positive Integer", 0, false, true));
        this.dimensionProperties.add(new PropertyDescription("minPycor", "min-pycor", "minimum y coordinate for patches", "Negative Integer", 0, false, true));
        this.dimensionProperties.add(new PropertyDescription("maxPycor", "max-pycor", "maximum y coordinate for patches", "Positive Integer", 0, false, true));
        this.dimensionProperties.add(new PropertyDescription("minPzcor", "min-pzcor", "minimum z coordinate for patches", "Negative Integer", 0, false, true));
        this.dimensionProperties.add(new PropertyDescription("maxPzcor", "max-pzcor", "maximum z coordinate for patches", "Positive Integer", 0, false, true));
    }

    public void addWrappingProperties() {
        this.wrappingProperties.add(new PropertyDescription("wrappingX", "World wraps X (east/west)", "Boolean", 0, false, true, false));
        this.wrappingProperties.add(new PropertyDescription("wrappingY", "World wraps Y (north/south)", "Boolean", 0, false, true, false));
        this.wrappingProperties.add(new PropertyDescription("wrappingZ", "World wraps Z (top/bottom)", "Boolean", 0, false, true, false));
    }

    public void addCornerChoices() {
        this.cornerChoices.add(new OriginConfiguration("Bottom Southwest", new boolean[]{false, true, false, true, false, true}, new boolean[]{true, false, true, false, true, false}));
        this.cornerChoices.add(new OriginConfiguration("Bottom Northwest", new boolean[]{false, true, true, false, false, true}, new boolean[]{true, false, false, true, true, false}));
        this.cornerChoices.add(new OriginConfiguration("Bottom Northeast", new boolean[]{true, false, true, false, false, true}, new boolean[]{false, true, false, true, true, false}));
        this.cornerChoices.add(new OriginConfiguration("Bottom Southeast", new boolean[]{true, false, false, true, false, true}, new boolean[]{false, true, true, false, true, false}));
        this.cornerChoices.add(new OriginConfiguration("Top Southwest", new boolean[]{false, true, false, true, true, false}, new boolean[]{true, false, true, false, false, true}));
        this.cornerChoices.add(new OriginConfiguration("Top Northwest", new boolean[]{false, true, true, false, true, false}, new boolean[]{true, false, false, true, false, true}));
        this.cornerChoices.add(new OriginConfiguration("Top Northeast", new boolean[]{true, false, true, false, true, false}, new boolean[]{false, true, false, true, false, true}));
        this.cornerChoices.add(new OriginConfiguration("Top Southeast", new boolean[]{true, false, false, true, true, false}, new boolean[]{false, true, true, false, false, true}));
    }

    public void addEdgeChoices() {
        this.edgeChoices.add(new OriginConfiguration("South", new boolean[]{true, true, false, true, true, true}, new boolean[]{false, false, true, false, false, false}));
        this.edgeChoices.add(new OriginConfiguration("North", new boolean[]{true, true, true, false, true, true}, new boolean[]{false, false, false, true, false, false}));
        this.edgeChoices.add(new OriginConfiguration("East", new boolean[]{true, false, true, true, true, true}, new boolean[]{false, true, false, false, false, false}));
        this.edgeChoices.add(new OriginConfiguration("West", new boolean[]{false, true, true, true, true, true}, new boolean[]{true, false, false, false, false, false}));
        this.edgeChoices.add(new OriginConfiguration("Bottom", new boolean[]{true, true, true, true, false, true}, new boolean[]{false, false, false, false, true, false}));
        this.edgeChoices.add(new OriginConfiguration("Top", new boolean[]{true, true, true, true, true, false}, new boolean[]{false, false, false, false, false, true}));
    }

    public void addOriginConfigurations() {
        this.originConfigurations.add(new OriginConfiguration("Center", new boolean[]{false, true, false, true, false, true}, new boolean[]{false, false, false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration("Corner", new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration("Edge", new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration("Custom", new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}));
    }

    public boolean editFinished() {
        this.gWidget.editFinished();
        if (this.wrappingChanged) {
            this.workspace.changeTopology(this.newWrapX, this.newWrapY);
            this.wrappingChanged = false;
        }
        if (this.edgesChanged || this.patchSizeChanged) {
            this.resizeWithProgress(true);
            this.edgesChanged = false;
            this.patchSizeChanged = false;
        }
        if (this.fontSizeChanged) {
            this.gWidget.applyNewFontSize(this.newFontSize);
            this.fontSizeChanged = false;
        }
        this.gWidget.view.dirty();
        this.gWidget.view.repaint();
        this.workspace.glView.editFinished();
        return true;
    }

    public void resizeWithProgress(boolean showProgress) {
        boolean oldGraphicsOn = this.world.displayOn();
        if (oldGraphicsOn) {
            this.world.displayOn(false);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (WorldViewSettings3D.this.edgesChanged) {
                    new Events.RemoveAllJobsEvent().raise(WorldViewSettings3D.this.gWidget);
                    WorldViewSettings3D.this.world.clearTurtles();
                    WorldViewSettings3D.this.world.clearLinks();
                    WorldViewSettings3D.this.world.createPatches(WorldViewSettings3D.this.newMinX, WorldViewSettings3D.this.newMaxX, WorldViewSettings3D.this.newMinY, WorldViewSettings3D.this.newMaxY, WorldViewSettings3D.this.newMinZ, WorldViewSettings3D.this.newMaxZ);
                    WorldViewSettings3D.this.workspace.patchesCreatedNotify();
                    WorldViewSettings3D.this.gWidget.resetSize();
                }
                if (WorldViewSettings3D.this.patchSizeChanged) {
                    WorldViewSettings3D.this.world.patchSize(WorldViewSettings3D.this.newPatchSize);
                    WorldViewSettings3D.this.gWidget.resetSize();
                }
                if (WorldViewSettings3D.this.edgesChanged) {
                    WorldViewSettings3D.this.workspace.clearDrawing();
                } else {
                    WorldViewSettings3D.this.gWidget.view.renderer.trailDrawer().rescaleDrawing();
                }
            }
        };
        if (showProgress) {
            new ModalProgressTask(Utils.getFrame(this.gWidget), runnable, "Resizing...");
        } else {
            runnable.run();
        }
        this.gWidget.displaySwitchOn(true);
        if (oldGraphicsOn) {
            this.world.displayOn(true);
            this.gWidget.view.dirty();
            this.gWidget.view.repaint();
        }
    }

    public void setDimensions(WorldDimensions d) {
        if (d instanceof WorldDimensions3D) {
            WorldDimensions3D dd = (WorldDimensions3D)d;
            this.setDimensions(dd.minPxcor, dd.maxPxcor, dd.minPycor, dd.maxPycor, dd.minPzcor, dd.maxPzcor);
        } else {
            this.setDimensions(d.minPxcor, d.maxPxcor, d.minPycor, d.maxPycor, 0, 0);
        }
    }

    public void setDimensions(int minPxcor, int maxPxcor, int minPycor, int maxPycor, int minPzcor, int maxPzcor) {
        this.newMinX = minPxcor;
        this.newMaxX = maxPxcor;
        this.newMinY = minPycor;
        this.newMaxY = maxPycor;
        this.newMinZ = minPzcor;
        this.newMaxZ = maxPzcor;
        if (minPxcor != this.world.minPxcor() || maxPxcor != this.world.maxPxcor() || minPycor != this.world.minPycor() || maxPycor != this.world.maxPycor() || minPzcor != this.world.minPzcor() || maxPzcor != this.world.maxPzcor()) {
            this.prepareForWorldResize();
            this.world.createPatches(minPxcor, maxPxcor, minPycor, maxPycor, minPzcor, maxPzcor);
            this.finishWorldResize();
        }
    }
}

