/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.nlogo.agent.AbstractExporter;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Observer;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.Thunk;
import org.nlogo.agent.World;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.File;
import org.nlogo.api.HubNetInterface;
import org.nlogo.api.HubNetWorkspaceInterface;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LocalFile;
import org.nlogo.api.LogoException;
import org.nlogo.api.ModelType;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.RemoteFile;
import org.nlogo.api.Token;
import org.nlogo.api.Version;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.job.JobManager;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.CompilerInterface;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.FileManager;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobManagerInterface;
import org.nlogo.nvm.MutableLong;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotException;
import org.nlogo.plot.PlotExporter;
import org.nlogo.plot.PlotManager;
import org.nlogo.util.Exceptions;
import org.nlogo.util.MersenneTwisterFast;
import org.nlogo.workspace.DefaultFileManager;
import org.nlogo.workspace.Evaluator;
import org.nlogo.workspace.ExtensionManager;
import org.nlogo.workspace.WorldLoader;
import org.nlogo.workspace.WorldLoader3D;
import org.nlogo.workspace.WorldLoaderInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class AbstractWorkspace
implements org.nlogo.agent.Evaluator,
HubNetWorkspaceInterface,
Workspace {
    public final World world;
    protected final DefaultFileManager fileManager;
    private final PlotManager plotManager = new PlotManager();
    public final JobManagerInterface jobManager;
    private final HubNetManagerFactory hubNetManagerFactory;
    protected HubNetInterface hubNetManager;
    private final Evaluator evaluator;
    private final ExtensionManager extensionManager;
    private final WeakHashMap<Job, WeakHashMap<Agent, WeakHashMap<Command, MutableLong>>> lastRunTimes = new WeakHashMap();
    protected String modelFileName;
    private String modelDir;
    private ModelType modelType;
    public String previewCommands = "setup repeat 75 [ go ]";
    private static boolean isApp = false;
    private static boolean isApplet = true;
    protected boolean computerHubNetRunning = false;
    private Map<String, Procedure> procedures = new HashMap<String, Procedure>();
    public WeakHashMap<String, Procedure> codeBits = new WeakHashMap();
    private Workspace.UpdateMode updateMode = Workspace.UpdateMode.CONTINUOUS;

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public FileManager fileManager() {
        return this.fileManager;
    }

    @Override
    public PlotManager plotManager() {
        return this.plotManager;
    }

    @Override
    public WeakHashMap<Job, WeakHashMap<Agent, WeakHashMap<Command, MutableLong>>> lastRunTimes() {
        return this.lastRunTimes;
    }

    protected AbstractWorkspace(World world, HubNetManagerFactory hubNetManagerFactory) {
        this.world = world;
        this.hubNetManagerFactory = hubNetManagerFactory;
        this.modelType = ModelType.NEW;
        this.evaluator = new Evaluator(this);
        world.setDefaultEvaluator(this);
        this.jobManager = new JobManager(this, world, world);
        this.fileManager = new DefaultFileManager(this);
        this.extensionManager = new ExtensionManager(this);
    }

    @Override
    public org.nlogo.api.ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public boolean isExtensionName(String name) {
        return this.extensionManager.isExtensionName(name);
    }

    @Override
    public void importExtensionData(String name, List<String[]> data, ImportErrorHandler handler) throws ExtensionException {
        this.extensionManager.importExtensionData(name, data, handler);
    }

    public boolean isCompilerTestingMode() {
        return false;
    }

    public boolean warningMessage(String message) {
        System.err.println();
        System.err.println("WARNING: " + message);
        System.err.println();
        return true;
    }

    public static boolean isApp() {
        return isApp;
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void isApplet(boolean isApplet) {
        AbstractWorkspace.isApplet = isApplet;
    }

    @Override
    public boolean getIsApplet() {
        return isApplet;
    }

    public HubNetInterface getHubNetManager() {
        if (this.hubNetManager == null && this.hubNetManagerFactory != null) {
            this.hubNetManager = this.hubNetManagerFactory.newInstance(this);
        }
        return this.hubNetManager;
    }

    public HubNetInterface hubnetManager() {
        return this.hubNetManager;
    }

    public boolean computerHubNetRunning() {
        return this.computerHubNetRunning;
    }

    @Override
    public void computerHubNetRunning(boolean computerHubNetRunning) {
        this.computerHubNetRunning = computerHubNetRunning;
    }

    @Override
    public WorldPropertiesInterface getPropertiesInterface() {
        return null;
    }

    public void setModelPath(String modelPath) {
        if (modelPath == null) {
            this.modelFileName = null;
            this.modelDir = null;
        } else {
            java.io.File file = new java.io.File(modelPath).getAbsoluteFile();
            this.modelFileName = file.getName();
            this.modelDir = file.getParent();
            if (this.modelDir.equals("")) {
                this.modelDir = null;
            }
            if (this.modelDir != null) {
                this.fileManager.setPrefix(this.modelDir);
            }
        }
    }

    @Override
    public String attachModelDir(String filePath) throws MalformedURLException {
        if (AbstractWorkspace.isApplet() || new java.io.File(filePath).isAbsolute()) {
            return filePath;
        }
        String path = this.getModelPath();
        if (path == null) {
            path = System.getProperty("user.home") + java.io.File.separatorChar + "dummy.txt";
        }
        URL urlForm = new URL(AbstractWorkspace.toURL(new java.io.File(path)), filePath);
        return new java.io.File(urlForm.getFile()).getAbsolutePath();
    }

    private static URL toURL(java.io.File file) throws MalformedURLException {
        return file.toURL();
    }

    @Override
    public void convertToNormal() throws IOException {
        java.io.File svn = new java.io.File(this.attachModelDir(".svn"));
        if (!svn.exists() || !svn.isDirectory()) {
            throw new IOException("no SVN directory found");
        }
        this.modelType = ModelType.NORMAL;
    }

    protected void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    @Override
    public String getModelPath() {
        if (this.modelDir == null || this.modelFileName == null) {
            return null;
        }
        return this.modelDir + java.io.File.separatorChar + this.modelFileName;
    }

    @Override
    public String getModelFileName() {
        return this.modelFileName;
    }

    @Override
    public String getModelDir() {
        return this.modelDir;
    }

    @Override
    public String modelNameForDisplay() {
        return AbstractWorkspace.makeModelNameForDisplay(this.modelFileName);
    }

    static String makeModelNameForDisplay(String str) {
        if (str == null) {
            return "Untitled";
        }
        int suffixIndex = str.lastIndexOf(".nlogo");
        if (suffixIndex > 0 && suffixIndex == str.length() - 6) {
            str = str.substring(0, str.length() - 6);
        }
        return str;
    }

    @Override
    public Map<String, Procedure> getProcedures() {
        return this.procedures;
    }

    @Override
    public void setProcedures(Map<String, Procedure> procedures) {
        this.procedures = procedures;
    }

    public void init() {
        for (Procedure procedure : this.procedures.values()) {
            procedure.init(this);
        }
    }

    @Override
    public void clearAll() {
        this.world.clearAll();
        this.clearOutput();
        this.clearDrawing();
        this.plotManager.clearAll();
        this.extensionManager.clearAll();
    }

    @Override
    public void joinForeverButtons(Agent agent) {
        this.jobManager.joinForeverButtons(agent);
    }

    @Override
    public void addJobFromJobThread(Job job) {
        this.jobManager.addJobFromJobThread(job);
    }

    @Override
    public Procedure compileForRun(String source2, Context context, boolean reporter) throws CompilerException {
        String key = source2 + "@" + context.activation.procedure.args.size() + "@" + context.agentBit;
        Procedure proc = this.codeBits.get(key);
        if (proc == null) {
            proc = this.evaluator.compileForRun(source2, context, reporter);
            this.codeBits.put(key, proc);
        }
        return proc;
    }

    public Workspace.UpdateMode updateMode() {
        return this.updateMode;
    }

    public void updateMode(Workspace.UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    public void halt() {
        this.jobManager.haltPrimary();
        this.world.displayOn(true);
    }

    @Override
    public void outputObject(Object object, Object owner, boolean addNewline, boolean readable, Workspace.OutputDestination destination) throws LogoException {
        OutputObject oo = new OutputObject(owner instanceof Agent ? Dump.logoObject(owner) : "", (readable && !(owner instanceof Agent) ? " " : "") + Dump.logoObject(object, readable, false), addNewline, false);
        if (destination == Workspace.OutputDestination.FILE) {
            this.fileManager.writeOutputObject(oo);
        } else {
            this.sendOutput(oo, destination == Workspace.OutputDestination.OUTPUT_AREA);
        }
    }

    protected abstract void sendOutput(OutputObject var1, boolean var2) throws LogoException;

    @Override
    public void setOutputAreaContents(String text) {
        try {
            this.clearOutput();
            if (text.length() > 0) {
                this.sendOutput(new OutputObject("", text, false, false), true);
            }
        }
        catch (LogoException e) {
            Exceptions.handle(e);
        }
    }

    @Override
    public abstract void clearDrawing();

    protected void exportInterfaceGlobals(PrintWriter writer) {
        writer.println(Dump.csv.header("MODEL SETTINGS"));
        List<String> globals = this.world.program().interfaceGlobals;
        writer.println(Dump.csv.variableNameRow(globals));
        Object[] values = new Object[globals.size()];
        int i = 0;
        Iterator<String> iter = globals.iterator();
        while (iter.hasNext()) {
            values[i] = this.world.getObserverVariableByName(iter.next());
            ++i;
        }
        writer.println(Dump.csv.dataRow(values));
        writer.println();
    }

    @Override
    public void exportPlot(String plotName, String filename) throws IOException {
        final Plot plot = this.plotManager().getPlot(plotName);
        new AbstractExporter(filename){

            protected void export(PrintWriter writer) {
                AbstractWorkspace.this.exportInterfaceGlobals(writer);
                PlotExporter exporter = new PlotExporter(plot, Dump.csv);
                exporter.export(writer);
            }
        }.export("plot", this.modelFileName, "");
    }

    @Override
    public void exportAllPlots(String filename) throws IOException {
        new AbstractExporter(filename){

            protected void export(PrintWriter writer) {
                AbstractWorkspace.this.exportInterfaceGlobals(writer);
                String[] plotNames = AbstractWorkspace.this.plotManager().getPlotNames();
                for (int i = 0; i < plotNames.length; ++i) {
                    new PlotExporter(AbstractWorkspace.this.plotManager().getPlot(plotNames[i]), Dump.csv).export(writer);
                    writer.println();
                }
            }
        }.export("plots", this.modelFileName, "");
    }

    @Override
    public void exportWorld(String filename) throws IOException {
        new AbstractExporter(filename){

            protected void export(PrintWriter writer) {
                AbstractWorkspace.this.world.exportWorld(writer, true);
                AbstractWorkspace.this.exportDrawingToCSV(writer);
                AbstractWorkspace.this.exportOutputAreaToCSV(writer);
                AbstractWorkspace.this.exportPlotsToCSV(writer);
                AbstractWorkspace.this.extensionManager.exportWorld(writer);
            }
        }.export("world", this.modelFileName, "");
    }

    private void exportPlotsToCSV(PrintWriter writer) {
        writer.println(Dump.csv.encode("PLOTS"));
        try {
            Plot p = this.plotManager.currentPlot();
            writer.println(Dump.csv.encode(p.name()));
        }
        catch (PlotException e) {
            writer.println(Dump.csv.encode(""));
        }
        String[] plotNames = this.plotManager().getPlotNames();
        for (int i = 0; i < plotNames.length; ++i) {
            new PlotExporter(this.plotManager().getPlot(plotNames[i]), Dump.csv).export(writer);
            writer.println();
        }
    }

    public abstract void exportDrawingToCSV(PrintWriter var1);

    public abstract void exportOutputAreaToCSV(PrintWriter var1);

    protected abstract Importer.ErrorHandler getImporterErrorHandler();

    @Override
    public void importWorld(String filename) throws IOException {
        this.clearAll();
        this.doImport(new BufferedReaderImporter(filename){

            public void doImport(BufferedReader reader) throws IOException {
                AbstractWorkspace.this.world.importWorld(AbstractWorkspace.this.getImporterErrorHandler(), AbstractWorkspace.this, AbstractWorkspace.this.stringReader(), reader);
            }
        });
    }

    private final Importer.StringReader stringReader() {
        return new Importer.StringReader(){

            public Object readFromString(String s) throws Importer.StringReaderException {
                try {
                    return AbstractWorkspace.this.compiler().readFromString(s, AbstractWorkspace.this.world, AbstractWorkspace.this.extensionManager, AbstractWorkspace.this.world.program().is3D);
                }
                catch (CompilerException ex) {
                    throw new Importer.StringReaderException(ex.getMessage());
                }
            }
        };
    }

    @Override
    public void importDrawing(String filename) throws IOException {
        this.doImport(new FileImporter(filename){

            public void doImport(File file) throws IOException {
                AbstractWorkspace.this.importDrawing(file);
            }
        });
    }

    protected abstract void importDrawing(File var1) throws IOException;

    @Override
    public void currentPlot(String plot) {
        this.plotManager.setCurrentPlot(this.plotManager.getPlot(plot));
    }

    @Override
    public PlotInterface getPlot(String plot) {
        return this.plotManager.getPlot(plot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImport(BufferedReaderImporter importer) throws IOException {
        LocalFile file = new LocalFile(importer.filename);
        try {
            ((File)file).open(File.Mode.READ);
            importer.doImport(((File)file).getBufferedReader());
        }
        finally {
            try {
                ((File)file).close(false);
            }
            catch (IOException ex2) {
                Exceptions.ignore(ex2);
            }
        }
    }

    protected void doImport(FileImporter importer) throws IOException {
        File newFile = AbstractWorkspace.isApplet() ? new RemoteFile(importer.filename) : new LocalFile(importer.filename);
        importer.doImport(newFile);
    }

    public String guessExportName(String defaultName) {
        String modelName = this.getModelFileName();
        if (modelName == null) {
            return defaultName;
        }
        int index = modelName.lastIndexOf(".nlogo");
        if (index > -1) {
            modelName = modelName.substring(0, index);
        }
        return modelName + " " + defaultName;
    }

    @Override
    public Thunk makeThunk(String source2, Agent agent, Object owner) throws CompilerException {
        return this.evaluator.makeThunk(source2, agent, (JobOwner)owner);
    }

    public void evaluateCommands(String source2) throws CompilerException {
        this.evaluator.evaluateCommands(source2);
    }

    @Override
    public void evaluateCommands(String source2, Agent agent, boolean waitForCompletion) throws CompilerException {
        this.evaluator.evaluateCommands(source2, agent, waitForCompletion);
    }

    public void evaluateCommands(String source2, Class<? extends Agent> agentClass, boolean waitForCompletion) throws CompilerException {
        this.evaluator.evaluateCommands(source2, agentClass, waitForCompletion);
    }

    @Override
    public Object evaluateReporter(String source2, Agent agent) throws CompilerException {
        return this.evaluator.evaluateReporter(source2, agent);
    }

    public Procedure compileCommands(String string) throws CompilerException {
        return this.compileCommands(string, Observer.class);
    }

    public Procedure compileCommands(String source2, Class<? extends Agent> agentClass) throws CompilerException {
        return this.evaluator.compileCommands(source2, agentClass);
    }

    public Procedure compileReporter(String source2) throws CompilerException {
        return this.evaluator.compileReporter(source2);
    }

    public boolean runCompiledCommands(Procedure procedure) {
        return this.evaluator.runCompiledCommands(procedure);
    }

    public Object runCompiledReporter(Procedure procedure) {
        return this.evaluator.runCompiledReporter(procedure);
    }

    @Override
    public boolean isConstant(String string) {
        return this.evaluator.isConstant(string);
    }

    @Override
    public Object readFromString(String string) throws CompilerException {
        return this.evaluator.readFromString(string);
    }

    public String getSource(String filename) throws IOException {
        File sourceFile;
        if (filename.equals("aggregate")) {
            return this.aggregateManager().innerSource();
        }
        if (AbstractWorkspace.isApplet()) {
            String url = this.fileManager().attachPrefix(filename);
            sourceFile = new RemoteFile(url);
        } else {
            sourceFile = new LocalFile(filename);
        }
        String source2 = sourceFile.readFile();
        return source2.replaceAll("\r\n", "\n");
    }

    @Override
    public String autoConvert(String source2, boolean subprogram, boolean reporter, String modelVersion) {
        return this.compiler().autoConvert(source2, subprogram, reporter, modelVersion, this, true, this.world().program().is3D);
    }

    public void loadWorld(String[] strings, String version, WorldLoaderInterface worldInterface) {
        WorldLoader loader = Version.is3D(version) ? new WorldLoader3D() : new WorldLoader();
        loader.load(strings, version, worldInterface);
    }

    @Override
    public MersenneTwisterFast auxRNG() {
        return this.world.auxRNG;
    }

    @Override
    public MersenneTwisterFast mainRNG() {
        return this.world.mainRNG;
    }

    @Override
    public Object readNumberFromString(String source2) throws CompilerException {
        return this.compiler().readNumberFromString(source2, this.world, this.getExtensionManager(), this.world.program().is3D);
    }

    @Override
    public void checkReporterSyntax(String source2) throws CompilerException {
        this.compiler().checkReporterSyntax(source2, this.world.program(), this.getProcedures(), this.getExtensionManager(), false);
    }

    @Override
    public void checkCommandSyntax(String source2) throws CompilerException {
        this.compiler().checkCommandSyntax(source2, this.world.program(), this.getProcedures(), this.getExtensionManager(), false);
    }

    @Override
    public boolean isValidIdentifier(String s) {
        return this.compiler().isValidIdentifier(s, this.world.program().is3D);
    }

    @Override
    public Token[] tokenizeForColorization(String s) {
        return this.compiler().tokenizeForColorization(s, this.getExtensionManager(), this.world.program().is3D);
    }

    @Override
    public Token getTokenAtPosition(String s, int pos) {
        return this.compiler().getTokenAtPosition(s, pos);
    }

    @Override
    public Map<String, List<Object>> findProcedurePositions(String source2) {
        return this.compiler().findProcedurePositions(source2, this.world.program().is3D);
    }

    public abstract CompilerInterface compiler();

    protected strictfp abstract class FileImporter {
        public String filename;

        FileImporter(String filename) {
            this.filename = filename;
        }

        public abstract void doImport(File var1) throws IOException;
    }

    protected strictfp abstract class BufferedReaderImporter {
        public String filename;

        BufferedReaderImporter(String filename) {
            this.filename = filename;
        }

        public abstract void doImport(BufferedReader var1) throws IOException;
    }

    public static interface HubNetManagerFactory {
        public HubNetInterface newInstance(AbstractWorkspace var1);
    }
}

